/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Boosting;

import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Boosting.FitnessABD;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Boosting.Fun;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Boosting.FuzzyClassifier;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Boosting.FuzzyRule;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Boosting.GeneticAlgorithmForBoosting;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Boosting.GenotypeBoosting;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Boosting.LinearSearchBrent;
import org.core.Randomize;

class AdaBoost
extends FuzzyClassifier {
    static Randomize r;

    AdaBoost(double[][] vejemplos, double[][] vdeseado, Randomize vr) {
        super(vejemplos, vdeseado);
        r = vr;
    }

    void CalculaPesosEjemplosABD(double[] w, int Clase, double[][][] Mu, double[] dsigno) {
        int i;
        int i2;
        double[] rr = this.InferenciaBanco(Clase, Mu);
        for (i2 = 0; i2 < this.nelem; ++i2) {
            w[i2] = 1.0;
        }
        for (i2 = 0; i2 < this.nelem; ++i2) {
            w[i2] = Math.abs(rr[i2]) > 0.0 ? w[i2] * Math.exp(-dsigno[i2] * rr[i2]) : w[i2] * Math.exp(0.0);
        }
        double suma = 0.0;
        for (i = 0; i < this.nelem; ++i) {
            suma += w[i];
        }
        i = 0;
        while (i < this.nelem) {
            int n = i++;
            w[n] = w[n] / suma;
        }
    }

    double Z(FuzzyRule regla, double[] w, int Clase, double alpha, double[][][] Mu, double[] dsigno) {
        double fitness = 0.0;
        double[] ca = this.CertezaAntecedente(regla, Mu);
        for (int i = 0; i < this.nelem; ++i) {
            if (Math.abs(ca[i]) > 0.0) {
                fitness += w[i] * Math.exp(-alpha * ca[i] * dsigno[i]);
                continue;
            }
            fitness += w[i] * Math.exp(Math.abs(alpha) * 0.0);
        }
        return fitness;
    }

    double CambiaConsReglaABD(FuzzyRule[] r, double[] w, int Clase, double[][][] Mu, double[] dsigno) {
        double alphaminimo = 0.0;
        ZFun MinZ = new ZFun(r[0], w, Clase, Mu, dsigno);
        double[] XBus = new double[]{0.0};
        double[] DBus = new double[]{1.0};
        LinearSearchBrent BL = new LinearSearchBrent(MinZ, DBus, XBus);
        alphaminimo = BL.EncuentraMinimoSimple();
        double fitness = this.Z(r[0], w, Clase, alphaminimo, Mu, dsigno);
        for (int i = 0; i < r[0].consecuente.length; ++i) {
            r[0].consecuente[i] = 0.0;
        }
        r[0].consecuente[Clase] = alphaminimo;
        return fitness;
    }

    int argmaxabs(double[] x) {
        double max = Math.abs(x[0]);
        int imax = 0;
        for (int i = 1; i < x.length; ++i) {
            if (!(Math.abs(x[i]) > max)) continue;
            max = Math.abs(x[i]);
            imax = i;
        }
        return imax;
    }

    void AnadeReglaABD2C(int c, double[][][] Mu, double[] w, double[] dsigno) {
        int i;
        int[] antecedente = new int[this.nentradas];
        double[] consecuente = new double[this.nsalidas];
        FuzzyRule result = new FuzzyRule(new int[this.nentradas], new double[this.nsalidas]);
        double minfit = 0.0;
        FuzzyRule TestRegla = new FuzzyRule(antecedente, consecuente);
        int permutaciones = 1;
        boolean maxint = false;
        for (int i2 = 0; i2 < result.antecedente.length; ++i2) {
            if (permutaciones < Integer.MAX_VALUE / (this.Etiquetas[i2].vertices.length + 1)) {
                permutaciones *= this.Etiquetas[i2].vertices.length + 1;
                continue;
            }
            maxint = true;
        }
        if (maxint) {
            System.out.println("Total permutaciones > 2147483647");
            permutaciones = Integer.MAX_VALUE;
        } else {
            System.out.println("Total permutaciones=" + permutaciones);
        }
        if (permutaciones < 1000) {
            double fc = 0.0;
            double minfc = 0.0;
            int q = 1;
            int perc = 0;
            for (int p = 0; p < permutaciones; ++p) {
                int i3;
                if (permutaciones > 100 && ++q > permutaciones / 100) {
                    System.out.println("Terminado " + perc + "%");
                    q = 0;
                    ++perc;
                }
                int cp = p;
                for (int i4 = 0; i4 < result.antecedente.length; ++i4) {
                    TestRegla.antecedente[i4] = cp % (this.Etiquetas[i4].vertices.length + 1);
                    cp /= this.Etiquetas[i4].vertices.length + 1;
                }
                TestRegla.consecuente[c] = 1.0;
                FuzzyRule[] ref = new FuzzyRule[]{TestRegla};
                fc = this.CambiaConsReglaABD(ref, w, c, Mu, dsigno);
                if (!(fc < minfc) && p != 0) continue;
                for (i3 = 0; i3 < result.antecedente.length; ++i3) {
                    result.antecedente[i3] = TestRegla.antecedente[i3];
                }
                for (i3 = 0; i3 < result.consecuente.length; ++i3) {
                    result.consecuente[i3] = TestRegla.consecuente[i3];
                }
                minfc = fc;
            }
        } else {
            int nlabels = this.Etiquetas[0].vertices.length;
            FitnessABD fitness = new FitnessABD(this, this.nentradas, this.nsalidas, nlabels, c, w, Mu, dsigno);
            GeneticAlgorithmForBoosting AG = new GeneticAlgorithmForBoosting(new GenotypeBoosting(this.nentradas, nlabels, r));
            GenotypeBoosting gen = AG.EncuentraMinimo(this.nentradas, nlabels, fitness, 250, r);
            FuzzyRule[] ref = new FuzzyRule[]{fitness.ConstruyeRegla(gen)};
            double fc = this.CambiaConsReglaABD(ref, w, c, Mu, dsigno);
            System.out.println("Z=" + fc);
            result = ref[0];
        }
        if (Math.abs(result.consecuente[this.argmaxabs(result.consecuente)]) < 0.0) {
            System.out.println("No se incorpora la regla");
            return;
        }
        FuzzyRule[] NuevoBanco = new FuzzyRule[this.BaseConocimiento.length + 1];
        for (i = 0; i < this.BaseConocimiento.length; ++i) {
            NuevoBanco[i] = this.BaseConocimiento[i];
        }
        NuevoBanco[this.BaseConocimiento.length] = new FuzzyRule(new int[this.nentradas], new double[this.nsalidas]);
        for (i = 0; i < this.nentradas; ++i) {
            NuevoBanco[this.BaseConocimiento.length].antecedente[i] = result.antecedente[i];
        }
        for (i = 0; i < this.nsalidas; ++i) {
            NuevoBanco[this.BaseConocimiento.length].consecuente[i] = result.consecuente[i];
        }
        this.BaseConocimiento = NuevoBanco;
        System.out.println("Regla anadida" + this.AString(result.antecedente) + "->" + this.AString(result.consecuente));
    }

    class ZFun
    extends Fun {
        FuzzyRule r;
        double[] w;
        double[][][] Mu;
        int C;
        double[] dsigno;

        ZFun(FuzzyRule vr, double[] vw, int vC, double[][][] vMu, double[] vdsigno) {
            this.r = vr;
            this.w = vw;
            this.C = vC;
            this.Mu = vMu;
            this.dsigno = vdsigno;
        }

        @Override
        public double evalua(double[] alpha) {
            return AdaBoost.this.Z(this.r, this.w, this.C, alpha[0], this.Mu, this.dsigno);
        }
    }
}

