/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.variables.delta;

import choco.cp.solver.variables.delta.iterators.BitSetIterator;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.solver.variables.delta.IDeltaDomain;
import java.util.BitSet;

public final class BitSetDeltaDomain
implements IDeltaDomain {
    private BitSet removedValues;
    private BitSet removedValuesToPropagate;
    private int offset;
    private BitSetIterator _iterator;

    private BitSetDeltaDomain() {
    }

    public BitSetDeltaDomain(int size, int theOffset) {
        this.removedValues = new BitSet(size);
        this.removedValuesToPropagate = new BitSet(size);
        this.offset = theOffset;
    }

    @Override
    public void freeze() {
        this.removedValuesToPropagate.clear();
        this.removedValuesToPropagate.or(this.removedValues);
    }

    @Override
    public void remove(int value) {
        this.removedValues.set(value - this.offset);
    }

    @Override
    public void clear() {
        this.removedValues.clear();
        this.removedValuesToPropagate.clear();
    }

    @Override
    public boolean isReleased() {
        return this.removedValues.isEmpty();
    }

    @Override
    public boolean release() {
        this.removedValues.andNot(this.removedValuesToPropagate);
        boolean empty = this.removedValues.isEmpty();
        this.removedValuesToPropagate.clear();
        return empty;
    }

    @Override
    public DisposableIntIterator iterator() {
        if (this._iterator == null) {
            this._iterator = new BitSetIterator();
        } else if (!this._iterator.reusable()) {
            assert (false);
            this._iterator = new BitSetIterator();
        }
        this._iterator.init(this.offset, this.removedValuesToPropagate);
        return this._iterator;
    }

    @Override
    public BitSetDeltaDomain copy() {
        BitSetDeltaDomain dom = new BitSetDeltaDomain();
        dom.removedValues = (BitSet)this.removedValues.clone();
        dom.removedValuesToPropagate = (BitSet)this.removedValuesToPropagate.clone();
        dom.offset = this.offset;
        return dom;
    }

    @Override
    public String pretty() {
        return "";
    }
}

