library(nbpMatching)

set.seed(1)
df <- data.frame(id=LETTERS[1:25], val1=rnorm(25), val2=rnorm(25))
df[sample(seq_len(nrow(df)), ceiling(nrow(df)*0.1)), 2] <- NA
df.dist <- gendistance(df, idcol=1, ndiscard=2)
mdm1 <- distancematrix(df.dist)
mdm2 <- distancematrix(df.dist$dist)
mdm3 <- distancematrix(as.matrix(df.dist$dist))
mdm4 <- distancematrix('sample_dist_mat_wrn.csv', row.names = 1)
mdm5 <- distancematrix('sample_dist_mat.csv')
expect_warning(mdm6 <- distancematrix(matrix(c(0,1,2,1,0,3,2,3,0), 3)))

expect_true(inherits(mdm1, 'distancematrix'))
expect_equal(dim(mdm1), c(28, 28))
expect_equal(mdm1, mdm2)
expect_equal(mdm1, mdm3)
expect_equal(mdm1, mdm4)
expect_equivalent(mdm1, mdm5)
expect_equal(dim(mdm6), c(4, 4))
expect_equal(rownames(mdm6), c(1,2,3,'ghost'))

expect_equal(rownames(distancematrix(matrix(c('A','B',0,1,1,0), 3, byrow = TRUE))), c('A','B'))
expect_equal(rownames(distancematrix(matrix(c('A','B',0,1,1,0), 2))), c('A','B'))
expect_equal(rownames(distancematrix(matrix(c(0,1,1,0), 2))), c('1','2'))

expect_error(distancematrix(df.dist$dist[FALSE,]))
expect_error(distancematrix(df.dist$dist[1:5,]))
expect_error(distancematrix(matrix(c('A','B','C','D'), 2)))
expect_error(distancematrix(matrix(1:4, 2)))
expect_error(distancematrix(list(matrix(c(0,1,1,0), 2))))
expect_error(distancematrix('test_distancematrix.R'))
expect_error(distancematrix('nofile'))
expect_error(mdm5[1,2] <- NA)
expect_error(mdm5[[2]] <- NA)
