/*
 * Decompiled with CFR 0.152.
 */
package eu.kliegr.ac1.data;

import eu.kliegr.ac1.data.Attribute;
import eu.kliegr.ac1.data.AttributeValue;
import eu.kliegr.ac1.rule.TestRule;
import java.util.ArrayList;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Transaction
implements Comparable {
    private static final Logger LOGGER = Logger.getLogger(Transaction.class.getName());
    private TestRule coveringRule;
    int internalTID;
    private final ArrayList<AttributeValue> attributeValues = new ArrayList();
    private final int firstTID;

    protected Transaction(int TID, int firstTID) {
        this.internalTID = TID;
        this.firstTID = firstTID;
    }

    public void setCoveringRule(TestRule coveringRule) {
        this.coveringRule = coveringRule;
    }

    public TestRule getCoveringRule() {
        return this.coveringRule;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("T: ").append(this.internalTID).append(":");
        String sep = "";
        for (AttributeValue value : this.attributeValues) {
            sb.append(sep);
            sb.append(value.getAttribute().getName()).append("=").append(value.toString());
            sep = " & ";
        }
        return sb.toString();
    }

    public int getInternalTID() {
        return this.internalTID;
    }

    public int getFirstTID() {
        return this.firstTID;
    }

    public AttributeValue getTarget() {
        for (AttributeValue v : this.attributeValues) {
            if (!v.getAttribute().isTargetAttribute) continue;
            return v;
        }
        return null;
    }

    public AttributeValue getValue(Attribute at) {
        for (AttributeValue v : this.attributeValues) {
            if (v.getAttribute() != at) continue;
            return v;
        }
        return null;
    }

    public String getExternalTID() {
        Optional<AttributeValue> extTID = this.attributeValues.stream().filter(a -> a.getAttribute().isIDAttribute).findFirst();
        if (extTID.isPresent()) {
            return extTID.get().value;
        }
        return "";
    }

    public void registerAttributeValue(AttributeValue value) {
        this.attributeValues.add(value);
    }

    protected void deregisterFromAllAttributeValues() {
        this.attributeValues.stream().map(value -> {
            LOGGER.log(Level.FINEST, "Deregistering trans with ID={0}(internal TID={1}) from values= '{'{2}'}'", new Object[]{this.getExternalTID(), this.getInternalTID(), value.toString()});
            return value;
        }).forEach(value -> value.removeTransaction(this));
    }

    protected void reregisterWithAllAttributeValues() {
        this.attributeValues.stream().map(value -> {
            LOGGER.log(Level.FINEST, "Registering trans with ID={0}(internal TID={1}) with values= '{'{2}'}'", new Object[]{this.getExternalTID(), this.getInternalTID(), value.toString()});
            return value;
        }).forEach(value -> value.addTransaction(this, false));
    }

    public int compareTo(Object o) {
        Transaction t2 = (Transaction)o;
        return this.internalTID - t2.internalTID;
    }
}

