## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
  )

## To silence warnings
require(gsignal, warn.conflicts = F)
require(tuneR, warn.conflicts = F)

## ----setup--------------------------------------------------------------------
library(ggplot2)
library(dplyr, warn.conflicts = F)
library(retimer)
data(mm1)

## ----tuner-example------------------------------------------------------------
tuner_spec <- spectrogram(mm1, method = 'tuner', output = 'list')


## ----tuner-plot, fig.width = 7, fig.height = 4, out.width = '100%'------------
with(tuner_spec, image(time, freq, amp, col = hcl.colors(20)))


## ----phontools-example--------------------------------------------------------
phontools_spec <- spectrogram(mm1, method = 'phontools')


## ----phontools-plot, fig.width = 7, fig.height = 3, out.width = '100%'--------
phontools_spec |>
    ggplot() +
    geom_raster(aes(t, f, fill = amp), show.legend = F) +
    scale_fill_viridis_c()


## ----all-example, fig.width = 7, fig.height = 10, out.width = '100%', warning = FALSE----
list(seewave = 'seewave', phontools = 'phontools', tuner = 'tuner', gsignal = 'gsignal') |>
    lapply(\(method) spectrogram(mm1, method = method)) |>
    bind_rows(.id = 'method') |>
    mutate(method = factor(method, levels = c('seewave', 'phontools', 'tuner', 'gsignal'))) |>
    group_by(method) |>
    mutate(amp = amp - min(amp),
           amp = amp / max(amp)) |>
    ungroup() |>
    ggplot() +
    geom_raster(aes(t, f, fill = amp), show.legend = F) +
    facet_grid(rows = vars(method)) +
    scale_fill_viridis_c()


