/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.colouring;

import dr.evolution.colouring.BranchColouring;
import dr.evolution.tree.ColourChange;
import java.util.ArrayList;
import java.util.List;

public class DefaultBranchColouring
implements BranchColouring {
    public static final boolean checkSanity = true;
    private final List<Integer> colourChanges = new ArrayList<Integer>(0);
    private final List<Double> changeHeights = new ArrayList<Double>(0);
    private int parentColour;
    private int childColour;

    public DefaultBranchColouring() {
        this.parentColour = -1;
    }

    public DefaultBranchColouring(int n, int n2) {
        this.parentColour = n;
        this.childColour = n2;
    }

    public DefaultBranchColouring(DefaultBranchColouring defaultBranchColouring) {
        this.parentColour = defaultBranchColouring.parentColour;
        this.childColour = defaultBranchColouring.childColour;
        this.colourChanges.addAll(defaultBranchColouring.colourChanges);
        this.changeHeights.addAll(defaultBranchColouring.changeHeights);
        this.finalSanityCheck();
    }

    public DefaultBranchColouring getCopy() {
        return new DefaultBranchColouring(this);
    }

    public void clear() {
        this.colourChanges.clear();
        this.changeHeights.clear();
    }

    public void reset(int n, int n2) {
        this.parentColour = n;
        this.childColour = n2;
        this.colourChanges.clear();
        this.changeHeights.clear();
    }

    @Override
    public int getParentColour() {
        return this.parentColour;
    }

    @Override
    public int getChildColour() {
        return this.childColour;
    }

    public void addEvent(int n, double d) {
        this.colourChanges.add(n);
        this.changeHeights.add(d);
        this.sanityCheck();
    }

    public void addHistory(DefaultBranchColouring defaultBranchColouring) {
        if (this.childColour != defaultBranchColouring.parentColour) {
            throw new Error("My child colour and the added parent colour don't match");
        }
        this.colourChanges.addAll(defaultBranchColouring.colourChanges);
        this.changeHeights.addAll(defaultBranchColouring.changeHeights);
        this.childColour = defaultBranchColouring.childColour;
        this.fullSanityCheck();
    }

    @Override
    public int getNumEvents() {
        return this.colourChanges.size();
    }

    @Override
    public int getForwardColourBelow(int n) {
        this.finalSanityCheck();
        if (n == 0) {
            return this.parentColour;
        }
        return this.colourChanges.get(n - 1);
    }

    @Override
    public double getForwardTime(int n) {
        this.finalSanityCheck();
        return this.changeHeights.get(n - 1);
    }

    @Override
    public int getBackwardColourAbove(int n) {
        this.finalSanityCheck();
        int n2 = this.colourChanges.size();
        if (n == n2) {
            return this.parentColour;
        }
        return this.colourChanges.get(n2 - 1 - n);
    }

    @Override
    public double getBackwardTime(int n) {
        this.finalSanityCheck();
        int n2 = this.colourChanges.size();
        return this.changeHeights.get(n2 - n);
    }

    @Override
    public int getNextForwardEvent(double d) {
        int n;
        for (n = 0; n < this.changeHeights.size() && this.changeHeights.get(n) > d; ++n) {
        }
        return n + 1;
    }

    @Override
    public double getTimeInColour(int n, double d, double d2) {
        double d3 = 0.0;
        int n2 = this.getForwardColourBelow(0);
        double d4 = d;
        for (int i = 1; i <= this.getNumEvents(); ++i) {
            double d5 = this.getForwardTime(i);
            if (n2 == n) {
                d3 += d4 - d5;
            }
            n2 = this.getForwardColourBelow(i);
            d4 = d5;
        }
        if (n2 == n) {
            d3 += d4 - d2;
        }
        return d3;
    }

    @Override
    public List<ColourChange> getColourChanges() {
        ArrayList<ColourChange> arrayList = new ArrayList<ColourChange>(0);
        for (int i = 1; i <= this.getNumEvents(); ++i) {
            arrayList.add(new ColourChange(this.getBackwardTime(i), this.getBackwardColourAbove(i)));
        }
        return arrayList;
    }

    private void sanityCheck() {
        int n = this.colourChanges.size();
        if (n > 0 && this.colourChanges.get(0) == this.parentColour) {
            throw new Error("First event does not change colour");
        }
        if (n > 1) {
            if (this.colourChanges.get(n - 1).intValue() == this.colourChanges.get(n - 2).intValue()) {
                throw new Error("Last event does not change colour");
            }
            if (this.changeHeights.get(n - 1) > this.changeHeights.get(n - 2)) {
                throw new Error("Child event occurs before parent event");
            }
        }
    }

    private void fullSanityCheck() {
        this.sanityCheck();
        int n = this.colourChanges.size();
        for (int i = 1; i < n; ++i) {
            if (this.colourChanges.get(i).intValue() == this.colourChanges.get(i - 1).intValue()) {
                throw new Error("Event " + i + " does not change colour");
            }
            if (!(this.changeHeights.get(i) > this.changeHeights.get(i - 1))) continue;
            throw new Error("Event " + i + " jumps back in time");
        }
    }

    private void finalSanityCheck() {
        if (this.parentColour == -1) {
            throw new Error("Parent colour has not been set");
        }
        int n = this.colourChanges.size();
        if (n > 0 && this.colourChanges.get(n - 1) != this.childColour) {
            throw new Error("Last event does not change colour into child's");
        }
    }
}

