/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.editor;

import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.rosuda.JGR.editor.EditorPreferences;

public class SyntaxDocument
extends DefaultStyledDocument {
    private static final long serialVersionUID = 6843788078390350530L;
    private static MutableAttributeSet BOLD = new SimpleAttributeSet();
    private DefaultStyledDocument doc = this;
    private Element rootElement = this.doc.getDefaultRootElement();

    public SyntaxDocument() {
        StyleConstants.setBold(BOLD, true);
        this.putProperty("__EndOfLine__", "\n");
    }

    @Override
    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        boolean whitespace = false;
        if (str.equals("\t")) {
            try {
                whitespace = this.getText(offset - 1, 1).matches("[\\s|#]");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!whitespace && offset != 0) {
                str = str.replaceAll("\t", "");
            } else {
                String tab = "";
                for (int i = 0; i < EditorPreferences.tabWidth; ++i) {
                    tab = tab + " ";
                }
                str = tab;
            }
        } else if (str.equals("\n")) {
            int off;
            int line = this.rootElement.getElementIndex(offset);
            int i = off = this.rootElement.getElement(line).getStartOffset();
            try {
                while (this.getText(i++, 1).matches("[\\t\\x0B\\f]")) {
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                str = "\n" + this.getText(off, i - off - 1).replaceAll("\n", "");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.insertString(offset, str, a);
    }

    @Override
    public void remove(int offset, int length) throws BadLocationException {
        if (offset == -1) {
            return;
        }
        super.remove(offset, length);
    }

    private synchronized void processChangedLines(int offset, int length) throws BadLocationException {
        String content = this.doc.getText(0, this.doc.getLength());
        int startLine = this.rootElement.getElementIndex(offset);
        int endLine = this.rootElement.getElementIndex(offset + length);
        for (int i = startLine; i <= endLine; ++i) {
            this.applyHighlighting(content, i);
        }
    }

    private synchronized void applyHighlighting(String content, int line) {
        int contentLength;
        int startOffset = this.rootElement.getElement(line).getStartOffset();
        int endOffset = this.rootElement.getElement(line).getEndOffset() - 1;
        int lineLength = endOffset - startOffset;
        if (lineLength < 0) {
            lineLength = 0;
        }
        if (endOffset >= (contentLength = content.length())) {
            endOffset = contentLength - 1;
        }
        this.doc.setCharacterAttributes(startOffset, lineLength, EditorPreferences.NORMAL, true);
        int index = content.indexOf(this.getSingleLineDelimiter(), startOffset);
        if (index > -1 && index < endOffset) {
            this.doc.setCharacterAttributes(index, endOffset - index + 1, EditorPreferences.COMMENT, false);
            endOffset = index - 1;
        }
        this.checkForTokens(content, startOffset, endOffset);
    }

    private synchronized void checkForTokens(String content, int startOffset, int endOffset) {
        while (startOffset <= endOffset) {
            while (this.isDelimiter(content.substring(startOffset, startOffset + 1))) {
                if (startOffset < endOffset) {
                    ++startOffset;
                    continue;
                }
                return;
            }
            if (this.isQuoteDelimiter(content.substring(startOffset, startOffset + 1))) {
                startOffset = this.getQuoteToken(content, startOffset, endOffset);
                continue;
            }
            startOffset = this.getOtherToken(content, startOffset, endOffset);
        }
    }

    private synchronized int getQuoteToken(String content, int startOffset, int endOffset) {
        String quoteDelimiter = content.substring(startOffset, startOffset + 1);
        String escapeString = this.getEscapeString(quoteDelimiter);
        int endOfQuote = startOffset;
        int index = content.indexOf(escapeString, endOfQuote + 1);
        while (index > -1 && index < endOffset) {
            endOfQuote = index + 1;
            index = content.indexOf(escapeString, endOfQuote);
        }
        index = content.indexOf(quoteDelimiter, endOfQuote + 1);
        endOfQuote = index < 0 || index > endOffset ? endOffset : index;
        this.doc.setCharacterAttributes(startOffset, endOfQuote - startOffset + 1, EditorPreferences.QUOTE, false);
        return endOfQuote + 1;
    }

    private synchronized int getOtherToken(String content, int startOffset, int endOffset) {
        int endOfToken;
        for (endOfToken = startOffset + 1; endOfToken <= endOffset && !this.isDelimiter(content.substring(endOfToken, endOfToken + 1)); ++endOfToken) {
        }
        String token = content.substring(startOffset, endOfToken);
        if (this.isKeyword(token)) {
            this.doc.setCharacterAttributes(startOffset, endOfToken - startOffset, EditorPreferences.KEYWORD, false);
        }
        if (this.isObject(token)) {
            this.doc.setCharacterAttributes(startOffset, endOfToken - startOffset, EditorPreferences.OBJECT, false);
        } else if (this.isNumber(token)) {
            this.doc.setCharacterAttributes(startOffset, endOfToken - startOffset, EditorPreferences.NUMBER, false);
        }
        return endOfToken + 1;
    }

    protected synchronized boolean isDelimiter(String character) {
        String operands = ",;:{}()[]+-/%<=>!&|^~*$";
        return Character.isWhitespace(character.charAt(0)) || operands.indexOf(character) != -1;
    }

    protected synchronized boolean isQuoteDelimiter(String character) {
        return "\"'".indexOf(character) >= 0;
    }

    protected synchronized boolean isKeyword(String token) {
        Object o = EditorPreferences.KEYWORDS.get(token);
        return o != null;
    }

    protected synchronized boolean isNumber(String token) {
        return token.matches("[[0-9]+.[0-9]+]*[0-9]+");
    }

    protected synchronized boolean isObject(String token) {
        Object o = EditorPreferences.KEYWORDS_OBJECTS.get(token);
        return o != null;
    }

    protected synchronized String getSingleLineDelimiter() {
        return "#";
    }

    protected synchronized String getEscapeString(String quoteDelimiter) {
        return "\\" + quoteDelimiter;
    }

    protected synchronized String addMatchingBrace(int offset) throws BadLocationException {
        String temp;
        StringBuffer whiteSpace = new StringBuffer();
        int line = this.rootElement.getElementIndex(offset);
        int i = this.rootElement.getElement(line).getStartOffset();
        while ((temp = this.doc.getText(i, 1)).equals(" ") || temp.equals("\t")) {
            whiteSpace.append(temp);
            ++i;
        }
        return "{\n" + whiteSpace.toString() + whiteSpace.toString() + "\n" + whiteSpace.toString() + "}";
    }

    @Override
    protected void fireInsertUpdate(DocumentEvent evt) {
        super.fireInsertUpdate(evt);
        try {
            this.processChangedLines(evt.getOffset(), evt.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    protected void fireRemoveUpdate(DocumentEvent evt) {
        super.fireRemoveUpdate(evt);
        try {
            this.processChangedLines(evt.getOffset(), evt.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

