/*
 * Decompiled with CFR 0.152.
 */
package javalain.math.fonction.simpleobjectif;

import java.util.Comparator;
import javalain.ea.SolutionEA;
import javalain.ea.operator.comparator.ObjectiveComparator;
import javalain.math.fonction.Fct;

public final class Schwefel_2
extends Fct {
    public Schwefel_2() {
        this(10);
    }

    public Schwefel_2(int d) {
        this.nomFct = "Schwefel_2";
        this.nbVariable = d;
        this.nbFctObjectif = 1;
        this.lowerLimit = new double[this.nbVariable];
        this.upperLimit = new double[this.nbVariable];
        for (int i = 0; i < this.nbVariable; ++i) {
            this.lowerLimit[i] = -500.0;
            this.upperLimit[i] = 500.0;
        }
    }

    @Override
    public double[] compute(double[] x) {
        ++this.nbEvaluation;
        double[] fct = new double[this.nbFctObjectif];
        fct[0] = 418.9829 * (double)this.nbVariable;
        for (int i = 0; i < this.nbVariable; ++i) {
            fct[0] = fct[0] + -x[i] * Math.sin(Math.sqrt(Math.abs(x[i])));
        }
        return fct;
    }

    @Override
    public double[][] getFront() {
        if (this.front == null) {
            this.front = new double[1][this.nbVariable];
            for (int i = 0; i < this.nbVariable; ++i) {
                this.front[0][i] = 420.9687;
            }
        }
        return this.front;
    }

    @Override
    public Comparator<SolutionEA> comparator() {
        return new ObjectiveComparator(0);
    }
}

