/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.Alatasetal;

import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.Alatasetal.AssociationRule;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.Alatasetal.Chromosome;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.Alatasetal.Gene;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.Alatasetal.myDataset;
import org.core.Randomize;

public class AlatasetalProcess {
    private final int ATTRIBUTE_NOT_COVERED = -1;
    private final int ATTRIBUTE_COVERED_BY_ANTECEDENT = 0;
    private final int ATTRIBUTE_COVERED_BY_CONSEQUENT = 1;
    private final int ATTRIBUTE_COVERED_BY_BOTH = 2;
    private myDataset dataset;
    private int nTrials;
    private int trials;
    private int randomChromosomes;
    private int r;
    private int tournamentSize;
    private double pc;
    private double pmMin;
    private double pmMax;
    private double a1;
    private double a2;
    private double a3;
    private double a4;
    private double a5;
    private double af;
    private int uPopSize;
    private int nAttr;
    private int nTrans;
    private double[] maxAmplitudes;
    private double minFitnessValue;
    private ArrayList<Chromosome> uPop;

    public AlatasetalProcess(myDataset dataset, int nTrials, int randomChromosomes, int r, int tournamentSize, double pc, double pmMin, double pmMax, double a1, double a2, double a3, double a4, double a5, double af) {
        double sum_max_amp = 0.0;
        this.dataset = dataset;
        this.nTrials = nTrials;
        this.randomChromosomes = randomChromosomes;
        this.r = r;
        this.tournamentSize = tournamentSize;
        this.pc = pc;
        this.pmMin = pmMin;
        this.pmMax = pmMax;
        this.a1 = a1;
        this.a2 = a2;
        this.a3 = a3;
        this.a4 = a4;
        this.a5 = a5;
        this.af = af;
        this.uPopSize = (int)Math.pow(2.0, this.r) * this.randomChromosomes;
        this.nAttr = this.dataset.getnVars();
        this.nTrans = this.dataset.getnTrans();
        this.maxAmplitudes = new double[this.nAttr];
        for (int i = 0; i < this.maxAmplitudes.length; ++i) {
            this.maxAmplitudes[i] = this.dataset.getMax(i) - this.dataset.getMin(i);
            sum_max_amp += this.maxAmplitudes[i];
        }
        this.minFitnessValue = -((double)this.nAttr + sum_max_amp + 100.0);
    }

    public void run() {
        int nGn = 0;
        this.trials = 0;
        System.out.print("Initializing Uniform Population... ");
        this.uPop = this.initializeUniformPopulation();
        this.evaluate(this.uPop, 0, this.uPop.size());
        Collections.sort(this.uPop);
        System.out.print("done.\n");
        while (this.trials < this.nTrials) {
            System.out.print("Computing Generation " + (nGn + 1) + "... ");
            while (this.uPop.size() < this.uPopSize * 2) {
                if (this.uPop.size() != this.uPopSize) {
                    if (Randomize.Rand() < 0.5) {
                        this.crossover(this.uPop);
                        continue;
                    }
                    this.mutate(this.uPop);
                    continue;
                }
                this.uniformOperator(this.uPop);
            }
            this.evaluate(this.uPop, this.uPopSize, this.uPop.size());
            this.computeAdjustedFitness(this.uPop);
            for (int i = 0; i < this.uPop.size(); ++i) {
                Chromosome c1 = this.uPop.get(i);
                for (int j = this.uPop.size() - 1; j > i + 1; --j) {
                    Chromosome c2 = this.uPop.get(j);
                    if (!c1.equals(c2)) continue;
                    this.uPop.remove(j);
                }
            }
            Collections.sort(this.uPop);
            while (this.uPop.size() > this.uPopSize) {
                this.uPop.remove(this.uPopSize);
            }
            ++nGn;
            System.out.print("done.\n");
        }
        this.adjustIntervals(this.uPop);
        this.removeRedundant(this.uPop);
    }

    public void removeRedundant(ArrayList<Chromosome> upop) {
        this.sortByAmplitude(upop);
        for (int i = 0; i < upop.size(); ++i) {
            boolean stop = false;
            for (int j = upop.size() - 1; j >= 0 && !stop; --j) {
                if (j == i) continue;
                Chromosome chromo1 = upop.get(i);
                Chromosome chromo2 = upop.get(j);
                if (chromo1.getnAnts() == chromo2.getnAnts()) {
                    if (!chromo1.isSubChromo(chromo2)) continue;
                    upop.remove(j);
                    if (j >= i) continue;
                    --i;
                    continue;
                }
                if (chromo1.getnAnts() <= chromo2.getnAnts()) continue;
                stop = true;
            }
        }
    }

    public void sortByAmplitude(ArrayList<Chromosome> pop) {
        for (int i = 0; i < pop.size() - 1; ++i) {
            for (int j = i + 1; j < pop.size(); ++j) {
                if (pop.get(j).getnAnts() >= pop.get(i).getnAnts()) continue;
                Chromosome temp = pop.get(i);
                pop.set(i, pop.get(j));
                pop.set(j, temp);
            }
        }
    }

    private boolean equalChromotoPop(Chromosome chromo_a, ArrayList<Chromosome> pop) {
        boolean equal_chr = false;
        for (int i = 0; !equal_chr && i < pop.size(); ++i) {
            if (!chromo_a.equals(pop.get(i))) continue;
            equal_chr = true;
        }
        return equal_chr;
    }

    public ArrayList<AssociationRule> generateRulesSet(double minSupport) {
        ArrayList<AssociationRule> rules = new ArrayList<AssociationRule>();
        ArrayList<Chromosome> chrFinal = new ArrayList<Chromosome>();
        for (int r = 0; r < this.uPop.size(); ++r) {
            Chromosome chr = this.uPop.get(r);
            if (!(chr.getRuleSupport() >= minSupport)) continue;
            rules.add(new AssociationRule(chr));
            chrFinal.add(chr);
        }
        return rules;
    }

    public void printReport(ArrayList<AssociationRule> rules) {
        int i;
        int cnt_cov_rec = 0;
        double avg_yulesQ = 0.0;
        double avg_sup = 0.0;
        double avg_conf = 0.0;
        double avg_ant_length = 0.0;
        double avg_lift = 0.0;
        double avg_conv = 0.0;
        double avg_CF = 0.0;
        double avg_netConf = 0.0;
        boolean[] cov_rec = new boolean[this.nTrans];
        for (i = 0; i < cov_rec.length; ++i) {
            cov_rec[i] = false;
        }
        for (int r = 0; r < rules.size(); ++r) {
            AssociationRule ar = rules.get(r);
            avg_sup += ar.getSupport();
            avg_conf += ar.getConfidence();
            avg_ant_length += (double)(ar.getIdOfAntecedents().size() + ar.getIdOfConsequents().size());
            avg_lift += ar.getLift();
            avg_conv += ar.getConv();
            avg_CF += ar.getCF();
            avg_netConf += ar.getnetConf();
            avg_yulesQ += ar.getyulesQ();
            ArrayList<Integer> cov_tids = ar.getCoveredTIDs();
            for (i = 0; i < cov_tids.size(); ++i) {
                int t = cov_tids.get(i);
                if (cov_rec[t]) continue;
                cov_rec[t] = true;
                ++cnt_cov_rec;
            }
        }
        System.out.println("\nNumber of Frequent Itemsets found: -");
        System.out.println("\nNumber of Association Rules generated: " + rules.size());
        if (!rules.isEmpty()) {
            System.out.println("Average Support: " + AlatasetalProcess.roundDouble(avg_sup / (double)rules.size(), 2));
            System.out.println("Average Confidence: " + AlatasetalProcess.roundDouble(avg_conf / (double)rules.size(), 2));
            System.out.println("Average Lift: " + AlatasetalProcess.roundDouble(avg_lift / (double)rules.size(), 2));
            System.out.println("Average Conviction: " + AlatasetalProcess.roundDouble(avg_conv / (double)rules.size(), 2));
            System.out.println("Average Certain Factor: " + AlatasetalProcess.roundDouble(avg_CF / (double)rules.size(), 2));
            System.out.println("Average Netconf: " + AlatasetalProcess.roundDouble(avg_netConf / (double)rules.size(), 2));
            System.out.println("Average YulesQ: " + AlatasetalProcess.roundDouble(avg_yulesQ / (double)rules.size(), 2));
            System.out.println("Average Number of Antecedents: " + AlatasetalProcess.roundDouble(avg_ant_length / (double)rules.size(), 2));
            System.out.println("Number of Covered Records (%): " + AlatasetalProcess.roundDouble(100.0 * (double)cnt_cov_rec / (double)this.nTrans, 2));
        }
    }

    public static double roundDouble(double number, int decimalPlace) {
        if (!Double.isInfinite(number) && !Double.isNaN(number)) {
            BigDecimal bd = new BigDecimal(number);
            bd = bd.setScale(decimalPlace, 0);
            double numberRound = bd.doubleValue();
            return numberRound;
        }
        return number;
    }

    public String printRules(ArrayList<AssociationRule> rules) {
        boolean stop = false;
        String rulesList = "";
        rulesList = rulesList + "Support\tantecedent_support\tconsequent_support\tConfidence\tLift\tConv\tCF\tNetConf\tYulesQ\tnAttributes\n";
        for (int i = 0; i < rules.size() && !stop; ++i) {
            int lenghtrule = rules.get(i).getAntecedents().length + rules.get(i).getConsequents().length;
            rulesList = rulesList + "" + AlatasetalProcess.roundDouble(rules.get(i).getSupport(), 2) + "\t" + AlatasetalProcess.roundDouble(rules.get(i).getAntecedentSupport(), 2) + "\t" + AlatasetalProcess.roundDouble(rules.get(i).getConsequentSupport(), 2) + "\t" + AlatasetalProcess.roundDouble(rules.get(i).getConfidence(), 2) + "\t" + AlatasetalProcess.roundDouble(rules.get(i).getLift(), 2) + "\t" + AlatasetalProcess.roundDouble(rules.get(i).getConv(), 2) + "\t" + AlatasetalProcess.roundDouble(rules.get(i).getCF(), 2) + "\t" + AlatasetalProcess.roundDouble(rules.get(i).getnetConf(), 2) + "\t" + AlatasetalProcess.roundDouble(rules.get(i).getyulesQ(), 2) + "\t" + lenghtrule + "\n";
        }
        return rulesList;
    }

    public void saveReport(ArrayList<AssociationRule> rules, PrintWriter w) {
        int i;
        int cnt_cov_rec = 0;
        double avg_yulesQ = 0.0;
        double avg_sup = 0.0;
        double avg_conf = 0.0;
        double avg_ant_length = 0.0;
        double avg_lift = 0.0;
        double avg_conv = 0.0;
        double avg_CF = 0.0;
        double avg_netConf = 0.0;
        boolean[] cov_rec = new boolean[this.nTrans];
        for (i = 0; i < cov_rec.length; ++i) {
            cov_rec[i] = false;
        }
        for (int r = 0; r < rules.size(); ++r) {
            AssociationRule ar = rules.get(r);
            avg_sup += ar.getSupport();
            avg_conf += ar.getConfidence();
            avg_ant_length += (double)(ar.getIdOfAntecedents().size() + ar.getIdOfConsequents().size());
            avg_lift += ar.getLift();
            avg_conv += ar.getConv();
            avg_CF += ar.getCF();
            avg_netConf += ar.getnetConf();
            avg_yulesQ += ar.getyulesQ();
            ArrayList<Integer> cov_tids = ar.getCoveredTIDs();
            for (i = 0; i < cov_tids.size(); ++i) {
                int t = cov_tids.get(i);
                if (cov_rec[t]) continue;
                cov_rec[t] = true;
                ++cnt_cov_rec;
            }
        }
        w.println("\nNumber of Frequent Itemsets found: -");
        System.out.println("\nNumber of Frequent Itemsets found: -");
        w.println("\nNumber of Association Rules generated: " + rules.size());
        System.out.println("\nNumber of Association Rules generated: " + rules.size());
        if (!rules.isEmpty()) {
            w.println("Average Support: " + AlatasetalProcess.roundDouble(avg_sup / (double)rules.size(), 2));
            System.out.println("Average Support: " + AlatasetalProcess.roundDouble(avg_sup / (double)rules.size(), 2));
            w.println("Average Confidence: " + AlatasetalProcess.roundDouble(avg_conf / (double)rules.size(), 2));
            System.out.println("Average Confidence: " + AlatasetalProcess.roundDouble(avg_conf / (double)rules.size(), 2));
            w.println("Average Lift: " + AlatasetalProcess.roundDouble(avg_lift / (double)rules.size(), 2));
            System.out.println("Average Lift: " + AlatasetalProcess.roundDouble(avg_lift / (double)rules.size(), 2));
            w.println("Average Conviction: " + AlatasetalProcess.roundDouble(avg_conv / (double)rules.size(), 2));
            System.out.println("Average Conviction: " + AlatasetalProcess.roundDouble(avg_conv / (double)rules.size(), 2));
            w.println("Average Certain Factor: " + AlatasetalProcess.roundDouble(avg_CF / (double)rules.size(), 2));
            System.out.println("Average Certain Factor: " + AlatasetalProcess.roundDouble(avg_CF / (double)rules.size(), 2));
            w.println("Average Netconf: " + AlatasetalProcess.roundDouble(avg_netConf / (double)rules.size(), 2));
            System.out.println("Average Netconf: " + AlatasetalProcess.roundDouble(avg_netConf / (double)rules.size(), 2));
            w.println("Average YulesQ: " + AlatasetalProcess.roundDouble(avg_yulesQ / (double)rules.size(), 2));
            System.out.println("Average YulesQ: " + AlatasetalProcess.roundDouble(avg_yulesQ / (double)rules.size(), 2));
            w.println("Average Number of Antecedents: " + AlatasetalProcess.roundDouble(avg_ant_length / (double)rules.size(), 2));
            System.out.println("Average Number of Antecedents: " + AlatasetalProcess.roundDouble(avg_ant_length / (double)rules.size(), 2));
            w.println("Number of Covered Records (%): " + AlatasetalProcess.roundDouble(100.0 * (double)cnt_cov_rec / (double)this.nTrans, 2));
            System.out.println("Number of Covered Records (%): " + AlatasetalProcess.roundDouble(100.0 * (double)cnt_cov_rec / (double)this.nTrans, 2));
        }
    }

    private ArrayList<Chromosome> initializeUniformPopulation() {
        int step = this.nAttr / this.r;
        int mod = this.nAttr % this.r;
        ArrayList<Chromosome> popInit = new ArrayList<Chromosome>();
        Gene[] rnd_genes = new Gene[this.nAttr];
        for (int cnt_chr = 0; cnt_chr < this.randomChromosomes; ++cnt_chr) {
            for (int g = 0; g < rnd_genes.length; ++g) {
                double ub;
                double lb;
                rnd_genes[g] = new Gene();
                int type_attr = this.dataset.getAttributeType(g);
                double min_attr = this.dataset.getMin(g);
                double max_attr = this.dataset.getMax(g);
                if (type_attr != 0) {
                    double top;
                    if (type_attr == 2) {
                        lb = Randomize.RanddoubleClosed(min_attr, max_attr);
                        top = Math.min(lb + this.maxAmplitudes[g], max_attr);
                        ub = Randomize.RanddoubleClosed(lb + 1.0E-4, top);
                    } else {
                        lb = Randomize.RandintClosed((int)min_attr, (int)max_attr);
                        top = Math.min(lb + this.maxAmplitudes[g], max_attr);
                        ub = Randomize.RandintClosed((int)lb + 1, (int)top);
                    }
                } else {
                    lb = ub = (double)Randomize.RandintClosed((int)min_attr, (int)max_attr);
                }
                rnd_genes[g].setLowerBound(lb);
                rnd_genes[g].setUpperBound(ub);
                rnd_genes[g].setAttr(g);
                rnd_genes[g].setType(this.dataset.getAttributeType(g));
                rnd_genes[g].setMin_attr(this.dataset.getMin(g));
                rnd_genes[g].setMax_attr(this.dataset.getMax(g));
                rnd_genes[g].setIsPositiveInterval(Randomize.RandintClosed(0, 1) == 1);
                rnd_genes[g].setActAs(Randomize.RandintClosed(-1, 1));
            }
            this.buildAllChromosomes(popInit, new Chromosome(rnd_genes), new boolean[this.r], 0, this.r, step, mod);
        }
        return popInit;
    }

    private void buildAllChromosomes(ArrayList<Chromosome> upop, Chromosome orig_chr, boolean[] mask, int p, int r, int step, int mod) {
        if (p == r - 1) {
            mask[p] = false;
            Chromosome chromo = this.buildChromosome(orig_chr, mask, step, mod);
            if (!this.equalChromotoPop(chromo, upop)) {
                upop.add(chromo.copy());
            }
            mask[p] = true;
            Chromosome chromo1 = this.buildChromosome(orig_chr, mask, step, mod);
            if (!this.equalChromotoPop(chromo1, upop)) {
                upop.add(chromo1.copy());
            }
        } else {
            mask[p] = false;
            this.buildAllChromosomes(upop, orig_chr, mask, p + 1, r, step, mod);
            mask[p] = true;
            this.buildAllChromosomes(upop, orig_chr, mask, p + 1, r, step, mod);
        }
    }

    private Chromosome buildChromosome(Chromosome c, boolean[] mask, int step, int mod) {
        Chromosome c_tmp = new Chromosome(c.getGenes());
        int end = 0;
        for (int i = 1; i <= mask.length; ++i) {
            int start = end;
            int n = end = mask.length - i >= mod ? start + step : start + step + 1;
            if (!mask[i - 1]) continue;
            for (int g = start; g < end; ++g) {
                c_tmp.getGene(g).invert(this.dataset.getAttributeType(g), this.dataset.getMin(g), this.dataset.getMax(g));
            }
        }
        c_tmp.forceConsistency();
        return c_tmp;
    }

    private void evaluate(ArrayList<Chromosome> upop, int start_index, int end_index) {
        for (int i = start_index; i < end_index; ++i) {
            this.computeFitness(upop.get(i));
        }
    }

    private void crossover(ArrayList<Chromosome> upop) {
        if (Randomize.Rand() < this.pc) {
            Chromosome offspring;
            Chromosome parent2;
            Chromosome parent1 = this.tournamentSelection(upop);
            if (!parent1.equals(parent2 = this.tournamentSelection(upop))) {
                Gene[] genes_offspring = new Gene[this.nAttr];
                for (int g = 0; g < this.nAttr; ++g) {
                    genes_offspring[g] = Randomize.Rand() < 0.5 ? parent1.getGene(g).copy() : parent2.getGene(g).copy();
                }
                offspring = new Chromosome(genes_offspring);
                offspring.forceConsistency();
            } else {
                offspring = new Chromosome(parent1.getGenes());
            }
            upop.add(offspring);
        }
    }

    private void mutate(ArrayList<Chromosome> upop) {
        int i;
        int cnt_hit = 0;
        Chromosome best_chr = upop.get(0);
        for (i = this.uPopSize; i < upop.size(); ++i) {
            if (!upop.get(i).equals(best_chr)) continue;
            ++cnt_hit;
        }
        for (i = 0; i < this.uPopSize && upop.size() < this.uPopSize * 2; ++i) {
            double top;
            double adaptive_ps = this.pmMin + (double)cnt_hit * ((this.pmMax - this.pmMin) / (double)(upop.size() - this.uPopSize));
            if (!(Randomize.Rand() < adaptive_ps)) continue;
            Chromosome chr = new Chromosome(upop.get(i).getGenes());
            int g = Randomize.Randint(0, this.nAttr);
            Gene gene = chr.getGene(g);
            double type_attr = this.dataset.getAttributeType(g);
            double min_attr = this.dataset.getMin(g);
            double max_attr = this.dataset.getMax(g);
            if (type_attr != 0.0) {
                if (type_attr == 2.0) {
                    if (Randomize.Rand() < 0.5) {
                        if (Randomize.Rand() < 0.5) {
                            top = Math.max(gene.getUpperBound() - this.maxAmplitudes[g], min_attr);
                            gene.setLowerBound(Randomize.RanddoubleClosed(top, gene.getLowerBound()));
                        } else {
                            gene.setLowerBound(Randomize.Randdouble(gene.getLowerBound(), gene.getUpperBound()));
                        }
                    } else if (Randomize.Rand() < 0.5) {
                        top = Math.min(gene.getLowerBound() + this.maxAmplitudes[g], max_attr);
                        gene.setUpperBound(Randomize.RanddoubleClosed(gene.getUpperBound(), top));
                    } else {
                        gene.setUpperBound(Randomize.RanddoubleClosed(gene.getLowerBound() + 1.0E-4, gene.getUpperBound()));
                    }
                } else if (Randomize.Rand() < 0.5) {
                    if (Randomize.Rand() < 0.5) {
                        top = Math.max(gene.getUpperBound() - this.maxAmplitudes[g], min_attr);
                        gene.setLowerBound(Randomize.RandintClosed((int)top, (int)gene.getLowerBound()));
                    } else {
                        gene.setLowerBound(Randomize.Randint((int)gene.getLowerBound(), (int)gene.getUpperBound()));
                    }
                } else if (Randomize.Rand() < 0.5) {
                    top = Math.min(gene.getLowerBound() + this.maxAmplitudes[g], max_attr);
                    gene.setUpperBound(Randomize.RandintClosed((int)gene.getUpperBound(), (int)top));
                } else {
                    gene.setUpperBound(Randomize.RandintClosed((int)gene.getLowerBound() + 1, (int)gene.getUpperBound()));
                }
            } else {
                top = Randomize.RandintClosed((int)min_attr, (int)max_attr);
                gene.setLowerBound(top);
                gene.setUpperBound(top);
            }
            gene.setIsPositiveInterval(Randomize.RandintClosed(0, 1) == 1);
            gene.setActAs(Randomize.RandintClosed(-1, 1));
            chr.forceConsistency();
            upop.add(chr);
            if (!chr.equals(best_chr)) continue;
            ++cnt_hit;
        }
    }

    private void uniformOperator(ArrayList<Chromosome> upop) {
        int r = 2;
        Chromosome chr1 = upop.get(0);
        Chromosome chr2 = upop.get(1);
        ArrayList<Integer> diff_pos = this.getDifferentPositions(chr1, chr2);
        ArrayList<Double> new_values = this.buildNewValues(chr1, chr2, diff_pos);
        int step = new_values.size() / r;
        int mod = new_values.size() % r;
        this.buildCombinationsOfNewValues(upop, chr1, new_values, diff_pos, new boolean[r], 0, r, step, mod);
    }

    private ArrayList<Integer> getDifferentPositions(Chromosome chr1, Chromosome chr2) {
        ArrayList<Integer> diff_pos = new ArrayList<Integer>();
        for (int g = 0; g < this.nAttr; ++g) {
            if (chr1.getGene(g).getActAs() != chr2.getGene(g).getActAs()) {
                diff_pos.add(g * 4);
            }
            if (chr1.getGene(g).getIsPositiveInterval() != chr2.getGene(g).getIsPositiveInterval()) {
                diff_pos.add(g * 4 + 1);
            }
            if (chr1.getGene(g).getLowerBound() != chr2.getGene(g).getLowerBound()) {
                diff_pos.add(g * 4 + 2);
            }
            if (chr1.getGene(g).getUpperBound() == chr2.getGene(g).getUpperBound()) continue;
            diff_pos.add(g * 4 + 3);
        }
        return diff_pos;
    }

    private ArrayList<Double> buildNewValues(Chromosome chr1, Chromosome chr2, ArrayList<Integer> diff_pos) {
        ArrayList<Double> new_values = new ArrayList<Double>();
        block6: for (int d = 0; d < diff_pos.size(); ++d) {
            int n = diff_pos.get(d);
            int p = n % 4;
            int g = (n - p) / 4;
            switch (p) {
                case 0: {
                    new_values.add(Double.valueOf(Randomize.RandintClosed(-1, 1)));
                    continue block6;
                }
                case 1: {
                    new_values.add(Double.valueOf(Randomize.RandintClosed(0, 1)));
                    continue block6;
                }
                case 2: {
                    if (this.dataset.getAttributeType(g) == 2) {
                        new_values.add((chr1.getGene(g).getLowerBound() + chr2.getGene(g).getLowerBound()) / 2.0);
                        continue block6;
                    }
                    new_values.add(Double.valueOf(Math.round((chr1.getGene(g).getLowerBound() + chr2.getGene(g).getLowerBound()) / 2.0)));
                    continue block6;
                }
                case 3: {
                    if (this.dataset.getAttributeType(g) == 2) {
                        new_values.add((chr1.getGene(g).getUpperBound() + chr2.getGene(g).getUpperBound()) / 2.0);
                        continue block6;
                    }
                    new_values.add(Double.valueOf(Math.round((chr1.getGene(g).getUpperBound() + chr2.getGene(g).getUpperBound()) / 2.0)));
                }
            }
        }
        return new_values;
    }

    private void buildCombinationsOfNewValues(ArrayList<Chromosome> upop, Chromosome orig_chr, ArrayList<Double> orig_values, ArrayList<Integer> diff_pos, boolean[] mask, int p, int r, int step, int mod) {
        if (p == r - 1) {
            mask[p] = false;
            Chromosome chromo = this.buildChromosomeFromDifferentValues(orig_chr, orig_values, diff_pos, mask, step, mod);
            upop.add(chromo.copy());
            mask[p] = true;
            Chromosome chromo1 = this.buildChromosomeFromDifferentValues(orig_chr, orig_values, diff_pos, mask, step, mod);
            upop.add(chromo.copy());
        } else {
            mask[p] = false;
            this.buildCombinationsOfNewValues(upop, orig_chr, orig_values, diff_pos, mask, p + 1, r, step, mod);
            mask[p] = true;
            this.buildCombinationsOfNewValues(upop, orig_chr, orig_values, diff_pos, mask, p + 1, r, step, mod);
        }
    }

    private Chromosome buildChromosomeFromDifferentValues(Chromosome orig_chr, ArrayList<Double> orig_values, ArrayList<Integer> diff_pos, boolean[] mask, int step, int mod) {
        Chromosome c_tmp = new Chromosome(orig_chr.getGenes());
        if ((double)step != 0.0) {
            int end = 0;
            for (int i = 1; i <= mask.length; ++i) {
                int start = end;
                end = mask.length - i >= mod ? start + step : start + step + 1;
                block12: for (int d = start; d < end; ++d) {
                    int n = diff_pos.get(d);
                    double v = orig_values.get(d);
                    int p = n % 4;
                    int g = (n - p) / 4;
                    switch (p) {
                        case 0: {
                            if (mask[i - 1]) {
                                switch ((int)v) {
                                    case -1: {
                                        c_tmp.getGene(g).setActAs(0);
                                        break;
                                    }
                                    case 0: {
                                        c_tmp.getGene(g).setActAs(1);
                                        break;
                                    }
                                    case 1: {
                                        c_tmp.getGene(g).setActAs(-1);
                                    }
                                }
                                continue block12;
                            }
                            c_tmp.getGene(g).setActAs((int)v);
                            continue block12;
                        }
                        case 1: {
                            if (mask[i - 1]) {
                                c_tmp.getGene(g).setIsPositiveInterval(v != 1.0);
                                continue block12;
                            }
                            c_tmp.getGene(g).setIsPositiveInterval(v == 1.0);
                            continue block12;
                        }
                        case 2: {
                            if (mask[i - 1]) {
                                if (this.dataset.getAttributeType(g) != 0) {
                                    if (this.dataset.getAttributeType(g) == 2) {
                                        c_tmp.getGene(g).setLowerBound(Randomize.RandClosed() * (v - this.dataset.getMin(g)) + this.dataset.getMin(g));
                                        continue block12;
                                    }
                                    c_tmp.getGene(g).setLowerBound(Randomize.RandintClosed((int)this.dataset.getMin(g), (int)v));
                                    continue block12;
                                }
                                if (v == this.dataset.getMax(g)) {
                                    c_tmp.getGene(g).setLowerBound(this.dataset.getMin(g));
                                    continue block12;
                                }
                                c_tmp.getGene(g).setLowerBound(v + 1.0);
                                continue block12;
                            }
                            c_tmp.getGene(g).setLowerBound(v);
                            continue block12;
                        }
                        case 3: {
                            if (mask[i - 1]) {
                                if (this.dataset.getAttributeType(g) != 0) {
                                    if (this.dataset.getAttributeType(g) == 2) {
                                        c_tmp.getGene(g).setUpperBound(Randomize.RandClosed() * (this.dataset.getMax(g) - v) + v);
                                        continue block12;
                                    }
                                    c_tmp.getGene(g).setUpperBound(Randomize.RandintClosed((int)v, (int)this.dataset.getMax(g)));
                                    continue block12;
                                }
                                if (v == this.dataset.getMax(g)) {
                                    c_tmp.getGene(g).setUpperBound(this.dataset.getMin(g));
                                    continue block12;
                                }
                                c_tmp.getGene(g).setUpperBound(v + 1.0);
                                continue block12;
                            }
                            c_tmp.getGene(g).setUpperBound(v);
                        }
                    }
                }
            }
            c_tmp.forceConsistency();
        }
        return c_tmp;
    }

    private Chromosome tournamentSelection(ArrayList<Chromosome> upop) {
        ArrayList<Chromosome> rnd_chrs = new ArrayList<Chromosome>();
        for (int cnt = 0; cnt < this.tournamentSize; ++cnt) {
            int rnd_index = Randomize.Randint(0, this.uPopSize);
            rnd_chrs.add(upop.get(rnd_index));
        }
        Collections.sort(rnd_chrs);
        return (Chromosome)rnd_chrs.get(0);
    }

    private void computeFitness(Chromosome c) {
        ArrayList<Integer> involved_attrs = c.getIndexOfInvolvedGenes();
        ArrayList<Integer> covered_tids = this.countSupport(c.getGenes(), involved_attrs);
        double all_sup = (double)covered_tids.size() / (double)this.nTrans;
        if (all_sup > 0.0) {
            double ant_sup = (double)this.countSupport(c.getGenes(), c.getIndexOfAntecedentGenes()).size() / (double)this.nTrans;
            double cons_sup = (double)this.countSupport(c.getGenes(), c.getIndexOfConsequentGenes()).size() / (double)this.nTrans;
            double conf = all_sup / ant_sup;
            c.setFitness(this.a1 * all_sup + this.a2 * conf - this.a3 * (double)involved_attrs.size() - this.a4 * this.sumInterval(c.getGenes(), involved_attrs));
            double lift = cons_sup == 0.0 || ant_sup == 0.0 ? 1.0 : all_sup / (ant_sup * cons_sup);
            double conv = cons_sup == 1.0 || ant_sup == 0.0 ? 1.0 : ant_sup * (1.0 - cons_sup) / (ant_sup - all_sup);
            double netConf = ant_sup == 0.0 || ant_sup == 1.0 || Math.abs(ant_sup * (1.0 - ant_sup)) <= 0.001 ? 0.0 : (all_sup - ant_sup * cons_sup) / (ant_sup * (1.0 - ant_sup));
            double numeratorYules = all_sup * (1.0 - cons_sup - ant_sup + all_sup) - (ant_sup - all_sup) * (cons_sup - all_sup);
            double denominatorYules = all_sup * (1.0 - cons_sup - ant_sup + all_sup) + (ant_sup - all_sup) * (cons_sup - all_sup);
            double yulesQ = ant_sup == 0.0 || ant_sup == 1.0 || cons_sup == 0.0 || cons_sup == 1.0 || Math.abs(denominatorYules) <= 0.001 ? 0.0 : numeratorYules / denominatorYules;
            double CF = 0.0;
            if (conf > cons_sup) {
                CF = (conf - cons_sup) / (1.0 - cons_sup);
            } else if (conf < cons_sup) {
                CF = (conf - cons_sup) / cons_sup;
            }
            c.setRuleSupport(all_sup);
            c.setAntecedentSupport(ant_sup);
            c.setConsequentSupport(cons_sup);
            c.setRuleConfidence(conf);
            c.setRuleLift(lift);
            c.setRuleConv(conv);
            c.setRuleCF(CF);
            c.setRuleNetconf(netConf);
            c.setRuleYulesQ(yulesQ);
            for (int t = 0; t < covered_tids.size(); ++t) {
                c.addCoveredTID(covered_tids.get(t));
            }
        } else {
            c.setFitness(this.minFitnessValue);
        }
        ++this.trials;
    }

    private double sumInterval(Gene[] genes, ArrayList<Integer> index_list) {
        double sum_interval = 0.0;
        for (int i = 0; i < index_list.size(); ++i) {
            int g = index_list.get(i);
            double lb = genes[g].getLowerBound();
            double ub = genes[g].getUpperBound();
            double amp = ub - lb;
            double interval = genes[g].getIsPositiveInterval() ? amp / this.af : (this.maxAmplitudes[g] - amp) / this.af;
            sum_interval += interval;
        }
        return sum_interval;
    }

    private void computeAdjustedFitness(ArrayList<Chromosome> upop) {
        int a;
        int k;
        int t;
        int j;
        ArrayList<Integer> cons_attrs;
        ArrayList<Integer> ant_attrs;
        ArrayList<Integer> covered_tids;
        Chromosome c;
        int i;
        int[][] marked_attr = new int[this.nTrans][this.nAttr];
        for (int m1 = 0; m1 < marked_attr.length; ++m1) {
            for (int m2 = 0; m2 < marked_attr[m1].length; ++m2) {
                marked_attr[m1][m2] = this.ATTRIBUTE_NOT_COVERED;
            }
        }
        for (i = 0; i < this.uPopSize; ++i) {
            c = upop.get(i);
            covered_tids = c.getCoveredTIDs();
            ant_attrs = c.getIndexOfAntecedentGenes();
            cons_attrs = c.getIndexOfConsequentGenes();
            for (j = 0; j < covered_tids.size(); ++j) {
                t = covered_tids.get(j);
                for (k = 0; k < ant_attrs.size(); ++k) {
                    a = ant_attrs.get(k);
                    if (marked_attr[t][a] == this.ATTRIBUTE_NOT_COVERED) {
                        marked_attr[t][a] = this.ATTRIBUTE_COVERED_BY_ANTECEDENT;
                        continue;
                    }
                    if (marked_attr[t][a] != this.ATTRIBUTE_COVERED_BY_CONSEQUENT) continue;
                    marked_attr[t][a] = this.ATTRIBUTE_COVERED_BY_BOTH;
                }
                for (k = 0; k < cons_attrs.size(); ++k) {
                    a = cons_attrs.get(k);
                    if (marked_attr[t][a] == this.ATTRIBUTE_NOT_COVERED) {
                        marked_attr[t][a] = this.ATTRIBUTE_COVERED_BY_CONSEQUENT;
                        continue;
                    }
                    if (marked_attr[t][a] != this.ATTRIBUTE_COVERED_BY_ANTECEDENT) continue;
                    marked_attr[t][a] = this.ATTRIBUTE_COVERED_BY_BOTH;
                }
            }
        }
        for (i = this.uPopSize; i < upop.size(); ++i) {
            c = upop.get(i);
            covered_tids = c.getCoveredTIDs();
            ant_attrs = c.getIndexOfAntecedentGenes();
            cons_attrs = c.getIndexOfConsequentGenes();
            int sum_marked = 0;
            for (j = 0; j < covered_tids.size(); ++j) {
                t = covered_tids.get(j);
                boolean ok = true;
                for (k = 0; k < ant_attrs.size() && ok; ++k) {
                    a = ant_attrs.get(k);
                    if (marked_attr[t][a] != this.ATTRIBUTE_NOT_COVERED && marked_attr[t][a] != this.ATTRIBUTE_COVERED_BY_CONSEQUENT) continue;
                    ok = false;
                }
                for (k = 0; k < cons_attrs.size() && ok; ++k) {
                    a = cons_attrs.get(k);
                    if (marked_attr[t][a] != this.ATTRIBUTE_NOT_COVERED && marked_attr[t][a] != this.ATTRIBUTE_COVERED_BY_ANTECEDENT) continue;
                    ok = false;
                }
                if (!ok) continue;
                ++sum_marked;
            }
            if (sum_marked <= 0) continue;
            c.setFitness(c.getFitness() - this.a5 * (double)sum_marked);
        }
    }

    private ArrayList<Integer> countSupport(Gene[] genes, ArrayList<Integer> index_list) {
        ArrayList<Integer> tid_list = new ArrayList<Integer>();
        double[][] trans = this.dataset.getTrueTransactions();
        for (int t = 0; t < this.nTrans; ++t) {
            boolean ok = true;
            for (int i = 0; i < index_list.size() && ok; ++i) {
                int g = index_list.get(i);
                double lb = genes[g].getLowerBound();
                double ub = genes[g].getUpperBound();
                if (genes[g].getIsPositiveInterval()) {
                    if (!(trans[t][g] < lb) && !(trans[t][g] > ub)) continue;
                    ok = false;
                    continue;
                }
                if (!(trans[t][g] >= lb) || !(trans[t][g] <= ub)) continue;
                ok = false;
            }
            if (!ok) continue;
            tid_list.add(t);
        }
        return tid_list;
    }

    private void adjustIntervals(ArrayList<Chromosome> upop) {
        double[][] trans = this.dataset.getTrueTransactions();
        for (int i = 0; i < upop.size(); ++i) {
            Chromosome chr = upop.get(i);
            Gene[] genes = chr.getGenes();
            ArrayList<Integer> cov_tids = chr.getCoveredTIDs();
            for (int g = 0; g < genes.length; ++g) {
                if (this.dataset.getAttributeType(g) == 0 || genes[g].getActAs() == -1) continue;
                if (genes[g].getIsPositiveInterval()) {
                    this.adjustPositiveInterval(genes[g], g, cov_tids, trans);
                    continue;
                }
                if (this.dataset.getAttributeType(g) == 2) {
                    this.adjustNegativeInterval(genes[g], g, cov_tids, trans, 1.0E-4);
                    continue;
                }
                this.adjustNegativeInterval(genes[g], g, cov_tids, trans, 1.0);
            }
        }
    }

    private void adjustPositiveInterval(Gene gene, int g, ArrayList<Integer> cov_tids, double[][] trans) {
        double min = gene.getUpperBound();
        double max = gene.getLowerBound();
        for (int r = 0; r < cov_tids.size(); ++r) {
            int t = cov_tids.get(r);
            if (trans[t][g] < min) {
                min = trans[t][g];
            }
            if (!(trans[t][g] > max)) continue;
            max = trans[t][g];
        }
        gene.setLowerBound(min);
        gene.setUpperBound(max);
    }

    private void adjustNegativeInterval(Gene gene, int g, ArrayList<Integer> cov_tids, double[][] trans, double delta) {
        double min = this.dataset.getMax(g) + delta;
        double max = this.dataset.getMin(g) - delta;
        for (int r = 0; r < cov_tids.size(); ++r) {
            int t = cov_tids.get(r);
            if (trans[t][g] < min && trans[t][g] > gene.getUpperBound()) {
                min = trans[t][g];
            }
            if (!(trans[t][g] > max) || !(trans[t][g] < gene.getLowerBound())) continue;
            max = trans[t][g];
        }
        gene.setLowerBound(max + delta);
        gene.setUpperBound(min - delta);
    }
}

