/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.Alatasetal;

import java.io.IOException;
import keel.Dataset.Attributes;
import keel.Dataset.Instance;
import keel.Dataset.InstanceSet;

public class myDataset {
    public static final int REAL = 2;
    public static final int INTEGER = 1;
    public static final int NOMINAL = 0;
    private double[][] trueTransactions = null;
    private boolean[][] missing = null;
    private double[] emax;
    private double[] emin;
    private int nTrans;
    private int nInputs;
    private int nOutputs;
    private int nVars;
    private InstanceSet IS = new InstanceSet();

    public double[][] getTrueTransactions() {
        return this.trueTransactions;
    }

    public double[] getemax() {
        return this.emax;
    }

    public double[] getemin() {
        return this.emin;
    }

    public double getMax(int variable) {
        return this.emax[variable];
    }

    public double getMin(int variable) {
        return this.emin[variable];
    }

    public int getnTrans() {
        return this.nTrans;
    }

    public int getnVars() {
        return this.nVars;
    }

    public boolean isMissing(int i, int j) {
        return this.missing[i][j];
    }

    public void readDataSet(String datasetFile) throws IOException {
        try {
            int i;
            this.IS.readSet(datasetFile, true);
            this.nTrans = this.IS.getNumInstances();
            this.nInputs = Attributes.getInputNumAttributes();
            this.nOutputs = Attributes.getOutputNumAttributes();
            this.nVars = this.nInputs + this.nOutputs;
            this.trueTransactions = new double[this.nTrans][this.nVars];
            this.missing = new boolean[this.nTrans][this.nVars];
            this.emax = new double[this.nVars];
            this.emin = new double[this.nVars];
            for (i = 0; i < this.nVars; ++i) {
                if (Attributes.getAttribute(i).getType() != 0) {
                    this.emax[i] = Attributes.getAttribute(i).getMaxAttribute();
                    this.emin[i] = Attributes.getAttribute(i).getMinAttribute();
                    continue;
                }
                this.emin[i] = 0.0;
                this.emax[i] = Attributes.getAttribute(i).getNumNominalValues() - 1;
            }
            for (i = 0; i < this.nTrans; ++i) {
                int j;
                Instance inst = this.IS.getInstance(i);
                for (j = 0; j < this.nInputs; ++j) {
                    this.trueTransactions[i][j] = this.IS.getInputNumericValue(i, j);
                    this.missing[i][j] = inst.getInputMissingValues(j);
                    if (!this.missing[i][j]) continue;
                    this.trueTransactions[i][j] = this.emin[j] - 1.0;
                }
                if (this.nOutputs <= 0) continue;
                int k = 0;
                while (k < this.nOutputs) {
                    this.trueTransactions[i][j] = this.IS.getOutputNumericValue(i, k);
                    ++k;
                    ++j;
                }
            }
        }
        catch (Exception e) {
            System.out.println("DBG: Exception in readSet");
            e.printStackTrace();
        }
    }

    public boolean hasRealAttributes() {
        return Attributes.hasRealAttributes();
    }

    public boolean hasNumericalAttributes() {
        return Attributes.hasIntegerAttributes() || Attributes.hasRealAttributes();
    }

    public boolean hasMissingAttributes() {
        return this.sizeWithoutMissing() < this.getnTrans();
    }

    public int sizeWithoutMissing() {
        int tam = 0;
        for (int i = 0; i < this.nTrans; ++i) {
            int j;
            for (j = 1; j < this.nVars && !this.isMissing(i, j); ++j) {
            }
            if (j != this.nVars) continue;
            ++tam;
        }
        return tam;
    }

    public int numberValues(int attribute) {
        return Attributes.getInputAttribute(attribute).getNumNominalValues();
    }

    public boolean[] getMissing(int pos) {
        return this.missing[pos];
    }

    public String[] names() {
        String[] nombres = new String[this.nVars];
        for (int i = 0; i < this.nVars; ++i) {
            nombres[i] = Attributes.getInputAttribute(i).getName();
        }
        return nombres;
    }

    public String getNameVar(int pos) {
        return Attributes.getInputAttribute(pos).getName();
    }

    public int getAttributeType(int n_attr) {
        return Attributes.getInputAttribute(n_attr).getType();
    }
}

