/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Genetic.GFS_RB_MF;

import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.GFS_RB_MF.BaseD;
import org.core.Fichero;
import org.core.Randomize;

public class Individuo
implements Comparable {
    int[] cromosoma1;
    double[] cromosoma2;
    double[] max;
    double[] min;
    boolean n_e;
    double fitness;
    double ecm;
    int n_etiquetas;

    public Individuo() {
    }

    public Individuo(int n_variables, int n_etiquetas, int n_reglas, BaseD baseDatos) {
        int i;
        this.cromosoma1 = new int[n_reglas];
        this.cromosoma2 = new double[n_variables * n_etiquetas * 3];
        for (int i2 = 0; i2 < this.cromosoma1.length; ++i2) {
            this.cromosoma1[i2] = Randomize.RandintClosed(0, n_etiquetas - 1);
        }
        int k = 0;
        for (i = 0; i < n_variables; ++i) {
            for (int j = 0; j < n_etiquetas; ++j) {
                this.cromosoma2[k] = baseDatos.baseDatos[i][j].x0;
                this.cromosoma2[k + 1] = baseDatos.baseDatos[i][j].x1;
                this.cromosoma2[k + 2] = baseDatos.baseDatos[i][j].x3;
                k += 3;
            }
        }
        this.min = new double[k];
        this.max = new double[k];
        for (i = 0; i < k; i += 3) {
            this.min[i] = this.cromosoma2[i] - (this.cromosoma2[i + 1] - this.cromosoma2[i]) / 2.0;
            this.max[i] = this.cromosoma2[i] + (this.cromosoma2[i + 1] - this.cromosoma2[i]) / 2.0;
            this.min[i + 1] = this.cromosoma2[i + 1] - (this.cromosoma2[i + 1] - this.cromosoma2[i]) / 2.0;
            this.max[i + 1] = this.cromosoma2[i + 1] + (this.cromosoma2[i + 2] - this.cromosoma2[i + 1]) / 2.0;
            this.min[i + 2] = this.cromosoma2[i + 2] - (this.cromosoma2[i + 2] - this.cromosoma2[i + 1]) / 2.0;
            this.max[i + 2] = this.cromosoma2[i + 2] + (this.cromosoma2[i + 2] - this.cromosoma2[i + 1]) / 2.0;
        }
        this.n_etiquetas = n_etiquetas;
        this.n_e = true;
        this.fitness = 0.0;
        this.ecm = Double.MAX_VALUE;
    }

    public Individuo(int n_variables, int n_etiquetas, int n_reglas, double[] min, double[] max) {
        int i;
        this.cromosoma1 = new int[n_reglas];
        this.cromosoma2 = new double[n_variables * n_etiquetas * 3];
        for (i = 0; i < this.cromosoma1.length; ++i) {
            this.cromosoma1[i] = Randomize.RandintClosed(0, n_etiquetas - 1);
        }
        for (i = 0; i < this.cromosoma2.length; ++i) {
            this.cromosoma2[i] = min[i] + (max[i] - min[i]) * Randomize.Rand();
        }
        this.n_etiquetas = n_etiquetas;
        this.max = new double[max.length];
        this.max = (double[])max.clone();
        this.min = new double[min.length];
        this.min = (double[])min.clone();
        this.n_e = true;
        this.fitness = 0.0;
        this.ecm = Double.MAX_VALUE;
    }

    public Individuo(Individuo padre, Individuo madre, int puntoCorte) {
        int i;
        this.cromosoma1 = new int[padre.cromosoma1.length];
        this.cromosoma2 = new double[padre.cromosoma2.length];
        for (i = 0; i < puntoCorte; ++i) {
            this.cromosoma1[i] = padre.cromosoma1[i];
        }
        for (i = puntoCorte; i < this.cromosoma1.length; ++i) {
            this.cromosoma1[i] = madre.cromosoma1[i];
        }
        double d = 1.0;
        this.max = padre.dameIntervalosMax();
        this.min = padre.dameIntervalosMin();
        double[] cromP = padre.cromosoma2;
        double[] cromM = madre.cromosoma2;
        for (int i2 = 0; i2 < this.cromosoma2.length; ++i2) {
            double C1;
            double I = d * Math.abs(cromP[i2] - cromM[i2]);
            double A1 = cromP[i2] - I;
            if (A1 < this.min[i2]) {
                A1 = this.min[i2];
            }
            if ((C1 = cromP[i2] + I) > this.max[i2]) {
                C1 = this.max[i2];
            }
            this.cromosoma2[i2] = A1 + Randomize.Rand() * (C1 - A1);
        }
        this.n_etiquetas = padre.n_etiquetas;
        this.n_e = true;
        this.fitness = 0.0;
        this.ecm = Double.MAX_VALUE;
    }

    public void setFitness(double ecm) {
        this.fitness = 1.0 / (1.0 + ecm);
        this.ecm = ecm;
        this.n_e = false;
    }

    public Individuo clone() {
        Individuo ind = new Individuo();
        ind.cromosoma1 = (int[])this.cromosoma1.clone();
        ind.cromosoma2 = (double[])this.cromosoma2.clone();
        ind.fitness = this.fitness;
        ind.n_etiquetas = this.n_etiquetas;
        ind.ecm = this.ecm;
        ind.n_e = this.n_e;
        ind.max = this.dameIntervalosMax();
        ind.min = this.dameIntervalosMin();
        return ind;
    }

    public void mutar(double probMut) {
        int i;
        for (i = 0; i < this.cromosoma1.length; ++i) {
            if (!(Randomize.Rand() < probMut)) continue;
            this.cromosoma1[i] = Randomize.RandintClosed(0, this.n_etiquetas - 1);
        }
        for (i = 0; i < this.cromosoma2.length; ++i) {
            if (!(Randomize.Rand() < probMut)) continue;
            this.cromosoma2[i] = Randomize.RanddoubleClosed(this.min[i], this.max[i] - 1.0);
        }
    }

    public int compareTo(Object a) {
        if (((Individuo)a).fitness < this.fitness) {
            return -1;
        }
        if (((Individuo)a).fitness > this.fitness) {
            return 1;
        }
        return 0;
    }

    public String printString() {
        String cadena = new String("");
        return cadena;
    }

    public void print() {
        System.out.println(this.printString());
    }

    public void escribeFichero(String fichero) {
        Fichero.escribeFichero(fichero, this.printString());
    }

    public double[] dameIntervalosMin() {
        return (double[])this.min.clone();
    }

    public double[] dameIntervalosMax() {
        return (double[])this.max.clone();
    }
}

