/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.NNEP_Common;

import javolution.xml.XmlElement;
import javolution.xml.XmlFormat;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.INeuralNet;
import net.sf.jclec.IFitness;
import net.sf.jclec.IIndividual;
import net.sf.jclec.base.AbstractIndividual;
import net.sf.jclec.fitness.SimpleValueFitness;

public class NeuralNetIndividual
extends AbstractIndividual<INeuralNet> {
    protected static final XmlFormat<NeuralNetIndividual> XML = new XmlFormat<NeuralNetIndividual>(NeuralNetIndividual.class){

        @Override
        public void format(NeuralNetIndividual source, XmlElement xml) {
            XML.format(source, xml);
            xml.add(source.genotype, "genotype");
        }

        @Override
        public NeuralNetIndividual parse(XmlElement xml) {
            NeuralNetIndividual result = (NeuralNetIndividual)XML.parse(xml);
            result.genotype = xml.get("genotype");
            return result;
        }

        @Override
        public String defaultName() {
            return "neural-net-individual";
        }
    };
    private static final long serialVersionUID = -2245049003640033592L;

    public NeuralNetIndividual() {
    }

    public NeuralNetIndividual(INeuralNet genotype) {
        super(genotype);
    }

    public NeuralNetIndividual(INeuralNet genotype, IFitness fitness) {
        super(genotype, fitness);
    }

    @Override
    public IIndividual copy() {
        if (this.fitness != null) {
            return new NeuralNetIndividual(((INeuralNet)this.genotype).copy(), this.fitness.copy());
        }
        return new NeuralNetIndividual(((INeuralNet)this.genotype).copy());
    }

    @Override
    public double distance(IIndividual other) {
        return 0.0;
    }

    public boolean equals(Object other) {
        try {
            NeuralNetIndividual o = (NeuralNetIndividual)other;
            return ((INeuralNet)this.genotype).equals((INeuralNet)o.genotype);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("\"NeuralNetIndividual\" expected");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.renderNeuralNetIndividual());
        return sb.toString();
    }

    protected String renderNeuralNetIndividual() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.genotype);
        if (this.fitness != null) {
            sb.append("Fitness: " + ((SimpleValueFitness)this.fitness).getValue());
        } else {
            sb.append("Null Fitness");
        }
        return sb.toString();
    }
}

