/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core;

import keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core.Antd;
import keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core.AttributeWeka;
import keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core.Instance;
import keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core.Instances;
import keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core.Utils;

public class NominalAntd
extends Antd {
    static final long serialVersionUID = -9102297038837585135L;
    private double[] accurate;
    private double[] coverage;

    public NominalAntd(AttributeWeka a) {
        super(a);
        int bag = this.att.numValues();
        this.accurate = new double[bag];
        this.coverage = new double[bag];
    }

    @Override
    public Object copy() {
        NominalAntd antec = new NominalAntd(this.getAttr());
        antec.m_confidence = this.m_confidence;
        antec.value = this.value;
        return antec;
    }

    @Override
    public Instances[] splitData(Instances data, double defAcRt, double cl) {
        int x;
        int bag = this.att.numValues();
        Instances[] splitData = new Instances[bag];
        for (x = 0; x < bag; ++x) {
            splitData[x] = new Instances(data, data.numInstances());
            this.accurate[x] = 0.0;
            this.coverage[x] = 0.0;
        }
        for (x = 0; x < data.numInstances(); ++x) {
            Instance inst = data.instance(x);
            if (inst.isMissing(this.att)) continue;
            int v = (int)inst.value(this.att);
            splitData[v].add(inst);
            int n = v;
            this.coverage[n] = this.coverage[n] + inst.weight();
            if ((int)inst.classValue() != (int)cl) continue;
            int n2 = v;
            this.accurate[n2] = this.accurate[n2] + inst.weight();
        }
        for (x = 0; x < bag; ++x) {
            double p = this.accurate[x] + 1.0;
            double t = this.coverage[x] + 1.0;
            double infoGain = this.accurate[x] * (Utils.log2(p / t) - Utils.log2(defAcRt));
            if (!(infoGain > this.maxInfoGain)) continue;
            this.maxInfoGain = infoGain;
            this.cover = this.coverage[x];
            this.accu = this.accurate[x];
            this.accuRate = p / t;
            this.value = x;
        }
        return splitData;
    }

    @Override
    public double covers(Instance inst) {
        double isCover = 0.0;
        if (!inst.isMissing(this.att) && (int)inst.value(this.att) == (int)this.value) {
            isCover = 1.0;
        }
        return isCover;
    }

    @Override
    public String toString() {
        return this.att.name() + " = " + this.att.value((int)this.value);
    }
}

