/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.syntaxtree;

import net.sf.jclec.IConfigure;
import net.sf.jclec.ISpecies;
import net.sf.jclec.base.AbstractRecombinator;
import net.sf.jclec.syntaxtree.ISyntaxTreeSpecies;
import net.sf.jclec.syntaxtree.SyntaxTree;
import net.sf.jclec.syntaxtree.SyntaxTreeIndividual;
import org.apache.commons.configuration.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SyntaxTreeRecombinator<I extends SyntaxTreeIndividual>
extends AbstractRecombinator<I>
implements IConfigure {
    protected int targetTreeIndex = -1;
    protected transient ISyntaxTreeSpecies<I> species;
    protected transient ISyntaxTreeSpecies.ISyntaxTreeSchema[] schema;

    public int getTargetTreeIndex() {
        return this.targetTreeIndex;
    }

    public void setTargetTreeIndex(int targetTreeIndex) {
        this.targetTreeIndex = targetTreeIndex;
    }

    @Override
    public void configure(Configuration settings) {
        int targetTreeIndex = settings.getInt("target-tree-index", -1);
        this.setTargetTreeIndex(targetTreeIndex);
    }

    @Override
    protected void setPpl() {
        this.ppl = 2;
    }

    @Override
    protected void setSpl() {
        this.spl = 2;
    }

    @Override
    protected void prepareRecombination() {
        ISpecies species = this.context.getSpecies();
        if (!(species instanceof ISyntaxTreeSpecies)) {
            throw new IllegalStateException("Invalid species in context");
        }
        this.species = (ISyntaxTreeSpecies)species;
        this.schema = this.species.getGenotypeSchema();
    }

    @Override
    protected void recombineNext() {
        int nOfSyntaxTrees = this.species.getNumberOfSyntaxTrees();
        int actTargetTreeIndex = this.targetTreeIndex == -1 ? this.randgen.choose(0, nOfSyntaxTrees) : this.targetTreeIndex;
        SyntaxTree[] p0_genotype = (SyntaxTree[])((SyntaxTreeIndividual)this.parentsBuffer.get(this.parentsCounter++)).getGenotype();
        SyntaxTree[] p1_genotype = (SyntaxTree[])((SyntaxTreeIndividual)this.parentsBuffer.get(this.parentsCounter++)).getGenotype();
        SyntaxTree[] s0_genotype = new SyntaxTree[nOfSyntaxTrees];
        SyntaxTree[] s1_genotype = new SyntaxTree[nOfSyntaxTrees];
        int i = 0;
        while (i < nOfSyntaxTrees) {
            s0_genotype[i] = new SyntaxTree();
            s1_genotype[i] = new SyntaxTree();
            ++i;
        }
        i = 0;
        while (i < nOfSyntaxTrees) {
            if (i == actTargetTreeIndex) {
                this.recombine(p0_genotype[i], p1_genotype[i], s0_genotype[i], s1_genotype[i], this.schema[i]);
            } else {
                s0_genotype[i] = p0_genotype[i].copy();
                s1_genotype[i] = p1_genotype[i].copy();
            }
            ++i;
        }
        this.sonsBuffer.add(this.species.createIndividual(s0_genotype));
        this.sonsBuffer.add(this.species.createIndividual(s1_genotype));
    }

    protected abstract void recombine(SyntaxTree var1, SyntaxTree var2, SyntaxTree var3, SyntaxTree var4, ISyntaxTreeSpecies.ISyntaxTreeSchema var5);
}

