/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.problem.classification.stefano;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jclec.IConfigure;
import net.sourceforge.jclec.problem.classification.Individual;
import net.sourceforge.jclec.problem.classification.SyntaxTreeClassificationRule;
import net.sourceforge.jclec.problem.classification.blocks.And;
import net.sourceforge.jclec.problem.classification.blocks.AttributeValue;
import net.sourceforge.jclec.problem.classification.blocks.Equal;
import net.sourceforge.jclec.problem.classification.blocks.Greater;
import net.sourceforge.jclec.problem.classification.blocks.GreaterOrEqual;
import net.sourceforge.jclec.problem.classification.blocks.Less;
import net.sourceforge.jclec.problem.classification.blocks.LessOrEqual;
import net.sourceforge.jclec.problem.classification.blocks.Not;
import net.sourceforge.jclec.problem.classification.blocks.Or;
import net.sourceforge.jclec.problem.classification.blocks.RandomConstantOfContinuousValues;
import net.sourceforge.jclec.problem.classification.blocks.RandomConstantOfDiscreteValues;
import net.sourceforge.jclec.problem.classification.stefano.StefanoSyntaxTreeSchema;
import net.sourceforge.jclec.syntaxtree.NonTerminalNode;
import net.sourceforge.jclec.syntaxtree.SyntaxTree;
import net.sourceforge.jclec.syntaxtree.SyntaxTreeSpecies;
import net.sourceforge.jclec.syntaxtree.TerminalNode;
import net.sourceforge.jclec.util.dataset.IAttribute;
import net.sourceforge.jclec.util.dataset.IMetadata;
import net.sourceforge.jclec.util.dataset.IntegerAttribute;
import net.sourceforge.jclec.util.dataset.NumericalAttribute;
import org.apache.commons.configuration.Configuration;

public class StefanoSyntaxTreeSpecies
extends SyntaxTreeSpecies
implements IConfigure {
    private static final long serialVersionUID = 1L;
    private IMetadata metadata;
    private boolean existNumericalAttributes = false;

    public IMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(IMetadata dataSetSpecification) {
        this.metadata = dataSetSpecification;
    }

    public void setStefanoGrammar() {
        ArrayList<IAttribute> inputAttributes = new ArrayList<IAttribute>();
        int i = 0;
        while (i < this.metadata.numberOfAttributes()) {
            if (i != this.metadata.getClassIndex()) {
                inputAttributes.add(this.metadata.getAttribute(i));
            }
            ++i;
        }
        List<TerminalNode> terminals = this.setTerminalSymbols(inputAttributes);
        List<NonTerminalNode> nonTerminals = this.setNonTerminalSymbols(inputAttributes);
        this.genotypeSchema = new StefanoSyntaxTreeSchema();
        this.genotypeSchema.setRootSymbol("S");
        this.setTerminalNodes(terminals);
        this.setNonTerminalNodes(nonTerminals);
    }

    public void setMaxDerivSize(int maxDerivSize) {
        this.genotypeSchema.setMaxDerivSize(maxDerivSize);
    }

    public int getMaxDerivSize() {
        return this.genotypeSchema.getMaxDerivSize();
    }

    private List<TerminalNode> setTerminalSymbols(List<IAttribute> inputAttributes) {
        ArrayList<TerminalNode> terminals = new ArrayList<TerminalNode>();
        int numAttributes = inputAttributes.size();
        int i = 0;
        while (i < numAttributes) {
            IAttribute attribute = inputAttributes.get(i);
            TerminalNode term = new TerminalNode(attribute.getName(), new AttributeValue());
            ((AttributeValue)term.getCode()).setAttributeIndex(i);
            terminals.add(term);
            switch (attribute.getType()) {
                case DoubleNumerical: {
                    TerminalNode termValue = new TerminalNode("values" + attribute.getName(), new RandomConstantOfContinuousValues());
                    ((RandomConstantOfContinuousValues)termValue.getCode()).setInterval(((NumericalAttribute)attribute).intervalValues());
                    terminals.add(termValue);
                    this.existNumericalAttributes = true;
                    break;
                }
                case IntegerNumerical: {
                    TerminalNode termValue = new TerminalNode("values" + attribute.getName(), new RandomConstantOfDiscreteValues());
                    ((RandomConstantOfDiscreteValues)termValue.getCode()).setInterval(((IntegerAttribute)attribute).intervalValues());
                    terminals.add(termValue);
                    this.existNumericalAttributes = true;
                    break;
                }
                default: {
                    System.out.println("Type is not supported");
                }
            }
            ++i;
        }
        if (this.existNumericalAttributes) {
            terminals.add(new TerminalNode(">=", new GreaterOrEqual()));
            terminals.add(new TerminalNode(">", new Greater()));
            terminals.add(new TerminalNode("<=", new LessOrEqual()));
            terminals.add(new TerminalNode("<", new Less()));
            terminals.add(new TerminalNode("=", new Equal()));
        }
        terminals.add(new TerminalNode("AND", new And()));
        terminals.add(new TerminalNode("OR", new Or()));
        terminals.add(new TerminalNode("NOT", new Not()));
        return terminals;
    }

    private List<NonTerminalNode> setNonTerminalSymbols(List<IAttribute> inputAttributes) {
        ArrayList<NonTerminalNode> nonTerminals = new ArrayList<NonTerminalNode>();
        int numAttributes = inputAttributes.size();
        nonTerminals.add(new NonTerminalNode("S", new String[]{"A"}));
        nonTerminals.add(new NonTerminalNode("A", new String[]{"OR", "C", "C"}));
        nonTerminals.add(new NonTerminalNode("A", new String[]{"AND", "C", "C"}));
        nonTerminals.add(new NonTerminalNode("A", new String[]{"comparison"}));
        nonTerminals.add(new NonTerminalNode("A", new String[]{"comparison"}));
        nonTerminals.add(new NonTerminalNode("C", new String[]{"A"}));
        nonTerminals.add(new NonTerminalNode("C", new String[]{"NOT", "A"}));
        if (this.existNumericalAttributes) {
            nonTerminals.add(new NonTerminalNode("comparison", new String[]{"numerical_comparator", "numerical_attribute_comparison"}));
            nonTerminals.add(new NonTerminalNode("numerical_comparator", new String[]{">="}));
            nonTerminals.add(new NonTerminalNode("numerical_comparator", new String[]{">"}));
            nonTerminals.add(new NonTerminalNode("numerical_comparator", new String[]{"<="}));
            nonTerminals.add(new NonTerminalNode("numerical_comparator", new String[]{"<"}));
            nonTerminals.add(new NonTerminalNode("numerical_comparator", new String[]{"="}));
        }
        int i = 0;
        while (i < numAttributes) {
            IAttribute attribute = inputAttributes.get(i);
            String[] attr = new String[]{attribute.getName(), "values" + attribute.getName()};
            String[] attrInterval = new String[]{attribute.getName(), "values" + attribute.getName(), "values" + attribute.getName()};
            switch (attribute.getType()) {
                case DoubleNumerical: {
                    nonTerminals.add(new NonTerminalNode("numerical_attribute_comparison", attr));
                    nonTerminals.add(new NonTerminalNode("numerical_attribute_interval_comparison", attrInterval));
                    break;
                }
                case IntegerNumerical: {
                    nonTerminals.add(new NonTerminalNode("numerical_attribute_comparison", attr));
                    nonTerminals.add(new NonTerminalNode("numerical_attribute_interval_comparison", attrInterval));
                }
            }
            ++i;
        }
        return nonTerminals;
    }

    private void setTerminalNodes(List<TerminalNode> terminals) {
        TerminalNode[] terminalsAux = new TerminalNode[terminals.size()];
        int i = 0;
        for (TerminalNode t : terminals) {
            terminalsAux[i++] = (TerminalNode)t.copy();
        }
        this.genotypeSchema.setTerminals(terminalsAux);
    }

    private void setNonTerminalNodes(List<NonTerminalNode> nonTerminals) {
        NonTerminalNode[] nonTerminalsAux = new NonTerminalNode[nonTerminals.size()];
        int i = 0;
        for (NonTerminalNode t : nonTerminals) {
            nonTerminalsAux[i++] = (NonTerminalNode)t.copy();
        }
        this.genotypeSchema.setNonTerminals(nonTerminalsAux);
    }

    public Individual createIndividual() {
        return new Individual();
    }

    @Override
    public Individual createIndividual(SyntaxTree genotype) {
        SyntaxTreeClassificationRule rule = new SyntaxTreeClassificationRule();
        rule.setAntecedent(genotype);
        return new Individual(genotype, rule);
    }

    @Override
    public void configure(Configuration settings) {
    }
}

