## ----colorbox-----------------------------------------------------------------
#| include: false
library("colorize")
oi <- palette.colors(names = TRUE)


## -----------------------------------------------------------------------------
#| echo: fenced
#| eval: false
# `r colorize("Gentoo", "orange")` and  `r colorize("Adelie", "purple")` and
# `r colorize("Chinstrap", "darkgreen")` are Penguins.
# 
# This plot has `r colorize("red")` points, `r colorize("blue")` points,
# `r colorize("green")` points, which are nice!
# Other colors used in the plot are `r colorize("yellow")`, `r colorize("pink")`,
# `r colorize("gray")` and `r colorize("black")`.
# 
# As you can see, `r colorize("yellow")` and `r colorize("pink")` are illegible on a white background,
# but `r colorbox("yellow")` and `r colorbox("pink")` work fine.


## -----------------------------------------------------------------------------
oi <- palette.colors(names = TRUE) |>
  print()


## ----name-colors--------------------------------------------------------------
red <- colorize('red')
pink <- colorize("pink")
blue <- colorize('blue')
green <- colorize("green")
yellow <- colorize("yellow")
lightgreen <- colorize("lightgreen")
darkgreen <- colorize("darkgreen")


## -----------------------------------------------------------------------------
#| echo: fenced
#| eval: false
#| label: fig-Salaries-loess
#| fig-cap: !expr glue::glue("Scatterplot of Salary vs. years since PhD, adding the loess smooth. 
#|    The loess smooth curve and confidence band in {green} is nearly indistinguishable 
#|    from a quadratic fit in {blue}.")

# gg1 +
#   geom_smooth(method = "loess", formula = "y ~ x",
#               color = "blue", fill = scales::muted("blue"),
#               linewidth = 2) +
#   geom_smooth(method = "lm", formula = "y ~ x", se = FALSE,
#               color = "red",
#               linewidth = 2) +
#   geom_smooth(method = "lm", formula = "y ~ poly(x,2)",
#               color = "darkgreen", fill = "lightgreen",
#               linewidth = 2)

