/*
 * Decompiled with CFR 0.152.
 */
package org.corehunter.objectives.distance.measures;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.corehunter.data.CoreHunterData;
import org.corehunter.exceptions.CoreHunterException;
import org.corehunter.objectives.distance.measures.AbstractDistanceMeasure;
import uno.informatics.data.Feature;
import uno.informatics.data.Scale;
import uno.informatics.data.dataset.FeatureData;
import uno.informatics.data.dataset.FeatureDataRow;

public class GowerDistance
extends AbstractDistanceMeasure {
    private static final int BINARY = 0;
    private static final int NOMINAL = 1;
    private static final int ORDINAL = 2;
    private static final int RANGED = 3;
    private final Map<FeatureData, FeatureMetadata> cache = new HashMap<FeatureData, FeatureMetadata>();

    @Override
    public double computeDistance(int idX, int idY, CoreHunterData data) {
        if (idX == idY) {
            return 0.0;
        }
        FeatureData phenotypes = data.getPhenotypicData();
        if (phenotypes == null) {
            throw new CoreHunterException("Phenotypes are required for Gower distance.");
        }
        FeatureDataRow rowX = phenotypes.getRow(idX);
        FeatureDataRow rowY = phenotypes.getRow(idY);
        FeatureMetadata featureMetadata = this.getFeatureMetadata(phenotypes);
        int[] scaleTypes = featureMetadata.getScaleTypes();
        Scale[] scales = featureMetadata.getScales();
        double[] ranges = featureMetadata.getRanges();
        double distSum = 0.0;
        double weightSum = 0.0;
        for (int k = 0; k < featureMetadata.getNumFeatures(); ++k) {
            double distance = this.distance(scaleTypes[k], scales[k], ranges[k], rowX.getValue(k), rowY.getValue(k));
            double weight = this.weight(scaleTypes[k], rowX.getValue(k), rowY.getValue(k));
            distSum += distance * weight;
            weightSum += weight;
        }
        return distSum / weightSum;
    }

    private FeatureMetadata getFeatureMetadata(FeatureData data) {
        FeatureMetadata metadata = this.cache.get(data);
        if (metadata == null) {
            List<Feature> features = data.getFeatures();
            int numFeatures = features.size();
            int[] scaleTypes = new int[numFeatures];
            Scale[] scales = new Scale[numFeatures];
            double[] ranges = new double[numFeatures];
            block11: for (int k = 0; k < numFeatures; ++k) {
                Scale scale;
                scales[k] = scale = features.get(k).getMethod().getScale();
                switch (scale.getScaleType()) {
                    case NOMINAL: {
                        switch (scale.getDataType()) {
                            case BOOLEAN: {
                                scaleTypes[k] = 0;
                                continue block11;
                            }
                        }
                        scaleTypes[k] = 1;
                        continue block11;
                    }
                    case ORDINAL: {
                        scaleTypes[k] = 2;
                        if (scale.getValues().isEmpty()) {
                            throw new IllegalArgumentException("Ordered list of possible values should be provided for scale type " + (Object)((Object)scale.getScaleType()) + ".");
                        }
                        ranges[k] = scale.getValues().size() - 1;
                        continue block11;
                    }
                    case INTERVAL: 
                    case RATIO: {
                        switch (scale.getDataType()) {
                            case BIG_DECIMAL: 
                            case BIG_INTEGER: 
                            case DOUBLE: 
                            case FLOAT: 
                            case INTEGER: 
                            case LONG: 
                            case SHORT: {
                                scaleTypes[k] = 3;
                                ranges[k] = scale.getMaximumValue().doubleValue() - scale.getMinimumValue().doubleValue();
                                continue block11;
                            }
                        }
                        throw new IllegalArgumentException("Illegal data type " + (Object)((Object)scale.getDataType()) + " for scale type " + (Object)((Object)scale.getScaleType()));
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal scale type: " + (Object)((Object)scale.getScaleType()));
                    }
                }
            }
            metadata = new FeatureMetadata(scaleTypes, scales, ranges);
            this.cache.put(data, metadata);
        }
        return metadata;
    }

    private double distance(int scaleType, Scale scale, double range, Object elementA, Object elementB) {
        if (elementA != null && elementB != null) {
            switch (scaleType) {
                case 0: {
                    if (((Boolean)elementA).booleanValue() && ((Boolean)elementB).booleanValue()) {
                        return 0.0;
                    }
                    return 1.0;
                }
                case 2: {
                    if (range > 0.0) {
                        int indexA = scale.indexOf(elementA);
                        int indexB = scale.indexOf(elementB);
                        return (double)Math.abs(indexA - indexB) / range;
                    }
                    return 0.0;
                }
                case 1: {
                    if (Objects.equals(elementA, elementB)) {
                        return 0.0;
                    }
                    return 1.0;
                }
                case 3: {
                    if (range > 0.0) {
                        double aValue = ((Number)elementA).doubleValue();
                        double bValue = ((Number)elementB).doubleValue();
                        return Math.abs(aValue - bValue) / range;
                    }
                    return 0.0;
                }
            }
            throw new RuntimeException("This should not happen: unexpected scale type " + scaleType + " in Gower distance.");
        }
        return this.missingValueContribution(1.0);
    }

    private double weight(int scaleType, Object elementA, Object elementB) {
        if (elementA != null && elementB != null) {
            switch (scaleType) {
                case 0: {
                    if (((Boolean)elementA).booleanValue() || ((Boolean)elementB).booleanValue()) {
                        return 1.0;
                    }
                    return 0.0;
                }
                case 1: 
                case 2: 
                case 3: {
                    return 1.0;
                }
            }
            throw new RuntimeException("This should not happen: unexpected scale type " + scaleType + " in Gower distance.");
        }
        return 1.0;
    }

    public String toString() {
        return "Gower";
    }

    private class FeatureMetadata {
        private final int[] scaleTypes;
        private final Scale[] scales;
        private final double[] ranges;

        public FeatureMetadata(int[] gowerScaleTypes, Scale[] scaleTypes, double[] ranges) {
            this.scaleTypes = gowerScaleTypes;
            this.scales = scaleTypes;
            this.ranges = ranges;
        }

        public int getNumFeatures() {
            return this.scaleTypes.length;
        }

        public int[] getScaleTypes() {
            return this.scaleTypes;
        }

        public Scale[] getScales() {
            return this.scales;
        }

        public double[] getRanges() {
            return this.ranges;
        }
    }
}

