/*
 * Decompiled with CFR 0.152.
 */
package org.ipea.r5r;

import com.conveyal.r5.analyst.cluster.PathResult;
import com.conveyal.r5.analyst.fare.InRoutingFareCalculator;
import com.conveyal.r5.analyst.scenario.Scenario;
import com.conveyal.r5.api.util.SearchType;
import com.conveyal.r5.transit.TransitLayer;
import com.conveyal.r5.transit.TransportNetwork;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.ipea.r5r.Fares.RuleBasedInRoutingFareCalculator;
import org.ipea.r5r.JsonUtil;
import org.ipea.r5r.Scenario.DummyScenario;

public class RoutingProperties {
    public static final float DEFAULT_WALK_SPEED = 1.0f;
    public static final float DEFAULT_BIKE_SPEED = 3.3f;
    public static final int DEFAULT_MAX_RIDES = 3;
    public static final int DEFAULT_MAX_LEVEL_TRAFFIC_STRESS = 2;
    public static final int DEFAULT_SUBOPTIMAL_MINUTES = 0;
    public static final int DEFAULT_TIME_WINDOW_SIZE = 10;
    public static final int DEFAULT_NUMBER_OF_MONTE_CARLO_DRAWS = 50;
    public static final float DEFAULT_MAX_FARE = -1.0f;
    public static final int[] DEFAULT_PERCENTILES = new int[]{50};
    public static final int[] DEFAULT_CUTOFFS = new int[]{30};
    public static final float[] DEFAULT_FARE_CUTOFFS = new float[]{-1.0f};
    public double walkSpeed = 1.0;
    public double bikeSpeed = 3.3f;
    public int maxRides = 3;
    public int maxLevelTrafficStress = 2;
    public int suboptimalMinutes = 0;
    public int timeWindowSize = 10;
    public int numberOfMonteCarloDraws = 50;
    public int[] percentiles = DEFAULT_PERCENTILES;
    public int[] cutoffs = DEFAULT_CUTOFFS;
    public boolean travelTimesBreakdown = false;
    public boolean expandedTravelTimes = false;
    public PathResult.Stat travelTimesBreakdownStat = PathResult.Stat.MEAN;
    public float maxFare = -1.0f;
    public float[] fareCutoffs = DEFAULT_FARE_CUTOFFS;
    public InRoutingFareCalculator fareCalculator = null;
    public TransitLayer transitLayer = null;
    public SearchType searchType = SearchType.DEPART_FROM;
    private final TransportNetwork transportNetworkBase;
    public TransportNetwork transportNetworkWorking;
    private final Scenario dummyScenario = new DummyScenario();

    public void setFareCalculatorJson(String fareCalculatorJson) {
        try {
            ObjectNode node = (ObjectNode)JsonUtil.OBJECT_MAPPER.readValue(fareCalculatorJson, ObjectNode.class);
            this.fareCalculator = node.has("type") ? (InRoutingFareCalculator)JsonUtil.OBJECT_MAPPER.readValue(fareCalculatorJson, InRoutingFareCalculator.class) : new RuleBasedInRoutingFareCalculator(this.transitLayer, fareCalculatorJson);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public RoutingProperties(TransportNetwork network) {
        this.transportNetworkBase = network;
        this.transportNetworkWorking = this.transportNetworkBase.scenarioCopy(this.dummyScenario);
        this.transitLayer = network.transitLayer;
    }

    public void reset() {
        this.walkSpeed = 1.0;
        this.bikeSpeed = 3.3f;
        this.maxRides = 3;
        this.maxLevelTrafficStress = 2;
        this.suboptimalMinutes = 0;
        this.timeWindowSize = 10;
        this.numberOfMonteCarloDraws = 50;
        this.travelTimesBreakdown = false;
        this.travelTimesBreakdownStat = PathResult.Stat.MEAN;
        this.expandedTravelTimes = false;
        this.percentiles = DEFAULT_PERCENTILES;
        this.cutoffs = DEFAULT_CUTOFFS;
        this.fareCutoffs = DEFAULT_FARE_CUTOFFS;
        this.maxFare = -1.0f;
        this.fareCalculator = null;
        this.searchType = SearchType.DEPART_FROM;
        this.transportNetworkWorking = this.transportNetworkBase.scenarioCopy(this.dummyScenario);
    }

    public TransportNetwork getTransportNetworkBase() {
        return this.transportNetworkBase;
    }
}

