/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.GraphVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.logger.Logger;

public class ModelAnalyser {
    private final Model model;
    private static final Class[] VARS_TYPES = new Class[]{BoolVar.class, GraphVar.class, IntVar.class, RealVar.class, SetVar.class};
    private final Map<String, Map<String, List<Variable>>> mapTypeClassVars = new HashMap<String, Map<String, List<Variable>>>();
    private final Map<String, Map<String, List<Propagator>>> mapTypeClassCstrs = new HashMap<String, Map<String, List<Propagator>>>();

    public ModelAnalyser(Model model) {
        this.model = model;
    }

    public Model getModel() {
        return this.model;
    }

    private static String getClassName(Class c) {
        String[] sp = c.toString().split("\\.");
        return sp[sp.length - 1];
    }

    private void retrieveVariableData() {
        this.mapTypeClassVars.clear();
        for (Class c : VARS_TYPES) {
            Map<String, List<Variable>> typeMap = Arrays.stream(this.model.getVars()).filter(Objects::nonNull).filter(c::isInstance).filter(var -> !c.equals(IntVar.class) || !(var instanceof BoolVar)).collect(Collectors.groupingBy(var -> ModelAnalyser.getClassName(var.getClass())));
            if (typeMap.isEmpty()) continue;
            this.mapTypeClassVars.put(ModelAnalyser.getClassName(c), typeMap);
        }
    }

    private void retrievePropagatorData() {
        String[] cstrsTypes = (String[])Arrays.stream(this.model.getCstrs()).filter(Objects::nonNull).map(Constraint::getName).distinct().toArray(String[]::new);
        this.mapTypeClassCstrs.clear();
        for (String cstrName : cstrsTypes) {
            Map<String, List<Propagator>> typeMap = Arrays.stream(this.model.getCstrs()).filter(Objects::nonNull).filter(cstr -> cstrName.equals(cstr.getName())).flatMap(cstr -> Arrays.stream(cstr.getPropagators())).collect(Collectors.groupingBy(var -> ModelAnalyser.getClassName(var.getClass())));
            if (typeMap.isEmpty()) continue;
            this.mapTypeClassCstrs.put(cstrName, typeMap);
        }
    }

    private void retrieveModelData() {
        this.retrieveVariableData();
        this.retrievePropagatorData();
    }

    public VariableTypeStatistics[] analyseVariables() {
        this.retrieveVariableData();
        return (VariableTypeStatistics[])this.getVariableTypes().stream().map(c -> this.getVariableClassNamesOfType((String)c).stream().map(varType -> this.createVariableTypeStatistics((String)c, (String)varType)).collect(Collectors.toList())).flatMap(Collection::stream).toArray(VariableTypeStatistics[]::new);
    }

    public ConstraintTypeStatistics[] analyseConstraints() {
        this.retrievePropagatorData();
        return (ConstraintTypeStatistics[])this.getConstraintTypes().stream().map(c -> this.getConstraintClassNamesOfType((String)c).stream().map(propType -> this.createConstraintTypeStatistics((String)c, (String)propType)).collect(Collectors.toList())).flatMap(Collection::stream).toArray(ConstraintTypeStatistics[]::new);
    }

    public ModelAnalysis analyseModel() {
        VariableTypeStatistics[] varsTypeStats = this.analyseVariables();
        ConstraintTypeStatistics[] cstrsTypeStats = this.analyseConstraints();
        return new ModelAnalysis(varsTypeStats, cstrsTypeStats);
    }

    public List<String> getVariableTypes() {
        return this.mapTypeClassVars.keySet().stream().filter(c -> !this.mapTypeClassVars.get(c).isEmpty()).sorted().collect(Collectors.toList());
    }

    public List<String> getVariableClassNamesOfType(String variableType) {
        if (this.mapTypeClassVars.containsKey(variableType)) {
            return this.mapTypeClassVars.get(variableType).keySet().stream().sorted().collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    private List<Variable> retrieveVariablesWithProperty(Predicate<Variable> predicate) {
        return Arrays.stream(this.model.getVars()).filter(predicate).collect(Collectors.toList());
    }

    private List<Variable> getVariablesWithPropertyOfType(Predicate<Variable> predicate, String type) {
        return this.mapTypeClassVars.computeIfAbsent(type, s -> new HashMap()).values().stream().flatMap(Collection::stream).filter(predicate).collect(Collectors.toList());
    }

    public List<Variable> getUnconstrainedVariables() {
        return this.retrieveVariablesWithProperty(v -> v.getNbProps() == 0);
    }

    public List<Variable> getUnconstrainedVariables(String type) {
        return this.getVariablesWithPropertyOfType(v -> v.getNbProps() == 0, type);
    }

    public List<Variable> getVariablesWithViews() {
        return this.retrieveVariablesWithProperty(v -> v.getNbViews() > 0);
    }

    public List<Variable> getVariablesWithViews(String type) {
        return this.getVariablesWithPropertyOfType(v -> v.getNbViews() > 0, type);
    }

    public List<String> getConstraintTypes() {
        return this.mapTypeClassCstrs.keySet().stream().filter(c -> !this.mapTypeClassCstrs.get(c).isEmpty()).sorted().collect(Collectors.toList());
    }

    public List<String> getConstraintClassNamesOfType(String constraintType) {
        if (this.mapTypeClassCstrs.containsKey(constraintType)) {
            return this.mapTypeClassCstrs.get(constraintType).keySet().stream().sorted().collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    private List<Propagator> retrievePropagatorWithProperty(Predicate<Propagator> predicate) {
        return Arrays.stream(this.model.getCstrs()).map(Constraint::getPropagators).flatMap(Arrays::stream).filter(predicate).collect(Collectors.toList());
    }

    private List<Propagator> getPropagatorsWithPropertyOfType(Predicate<Propagator> predicate, String type) {
        return this.mapTypeClassCstrs.computeIfAbsent(type, s -> new HashMap()).values().stream().flatMap(Collection::stream).filter(predicate).collect(Collectors.toList());
    }

    public List<Propagator> getEntailedPropagators() {
        return this.retrievePropagatorWithProperty(p -> p.isEntailed().equals((Object)ESat.TRUE));
    }

    public List<Propagator> getEntailedPropagators(String type) {
        return this.getPropagatorsWithPropertyOfType(p -> p.isEntailed().equals((Object)ESat.TRUE), type);
    }

    public List<Propagator> getPassivePropagators() {
        return this.retrievePropagatorWithProperty(Propagator::isPassive);
    }

    public List<Propagator> getPassivePropagators(String type) {
        return this.getPropagatorsWithPropertyOfType(Propagator::isPassive, type);
    }

    public List<Propagator> getCompletelyInstantiatedPropagators() {
        return this.retrievePropagatorWithProperty(Propagator::isCompletelyInstantiated);
    }

    public List<Propagator> getCompletelyInstantiatedPropagators(String type) {
        return this.getPropagatorsWithPropertyOfType(Propagator::isCompletelyInstantiated, type);
    }

    public List<Propagator> getReifiedPropagators() {
        return this.retrievePropagatorWithProperty(Propagator::isReified);
    }

    public List<Propagator> getReifiedPropagators(String type) {
        return this.getPropagatorsWithPropertyOfType(Propagator::isReified, type);
    }

    private VariableTypeStatistics createVariableTypeStatistics(String varType, String classNameOfType) {
        return VariableTypeStatistics.createVariableTypeStatistics(this.mapTypeClassVars, varType, classNameOfType);
    }

    private ConstraintTypeStatistics createConstraintTypeStatistics(String cstrType, String classNameOfType) {
        return ConstraintTypeStatistics.createConstraintTypeStatistics(this.mapTypeClassCstrs, cstrType, classNameOfType);
    }

    private static <V> String prettyIntSizeMap(Map<Integer, Integer> map) {
        StringBuilder sb = new StringBuilder("{");
        List sortedArities = map.keySet().stream().sorted().collect(Collectors.toList());
        for (int i = 0; i < sortedArities.size(); ++i) {
            sb.append(sortedArities.get(i)).append(": ").append(map.get(sortedArities.get(i)));
            if (i + 1 >= sortedArities.size()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    private static <K, V> String prettyObjSizeMap(LinkedHashMap<K, Integer> map) {
        StringBuilder sb = new StringBuilder("{");
        ArrayList<K> sortedArities = new ArrayList<K>(map.keySet());
        for (int i = 0; i < sortedArities.size(); ++i) {
            sb.append(sortedArities.get(i)).append(": ").append(map.get(sortedArities.get(i)));
            if (i + 1 >= sortedArities.size()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    private void printVariableAnalysis(boolean retrieveData) {
        if (retrieveData) {
            this.retrieveVariableData();
        }
        Logger logger = this.model.getSolver().log();
        logger.green().println("BEGINNING OF VARIABLES ANALYSIS");
        for (String c : this.getVariableTypes()) {
            logger.blue().println(c);
            List<String> list = this.getVariableClassNamesOfType(c);
            for (int i = 0; i < list.size(); ++i) {
                String varType = list.get(i);
                VariableTypeStatistics varTypeStats = this.createVariableTypeStatistics(c, varType);
                logger.println(varTypeStats.toString(true, false, true));
                logger.println("");
            }
        }
        logger.red().println("END OF VARIABLES ANALYSIS");
    }

    public void printVariableAnalysis() {
        this.printVariableAnalysis(true);
    }

    private void printConstraintAnalysis(boolean retrieveData) {
        if (retrieveData) {
            this.retrievePropagatorData();
        }
        Logger logger = this.model.getSolver().log();
        logger.green().println("BEGINNING OF CONSTRAINTS ANALYSIS");
        for (String cstrType : this.getConstraintTypes()) {
            logger.blue().println(cstrType);
            List<String> list = this.getConstraintClassNamesOfType(cstrType);
            for (int i = 0; i < list.size(); ++i) {
                String propType = list.get(i);
                ConstraintTypeStatistics cstrTypeStats = this.createConstraintTypeStatistics(cstrType, propType);
                logger.println(cstrTypeStats.toString(true, false, true));
                logger.println("");
            }
        }
        logger.red().println("END OF CONSTRAINTS ANALYSIS");
    }

    public void printConstraintAnalysis() {
        this.printConstraintAnalysis(true);
    }

    public void printAnalysis() {
        this.retrieveModelData();
        Logger logger = this.model.getSolver().log();
        logger.println("");
        logger.green().println("BEGINNING OF MODEL ANALYSIS");
        logger.println("");
        this.printVariableAnalysis(false);
        logger.println("");
        this.printConstraintAnalysis(false);
        logger.println("");
        logger.red().println("END OF MODEL ANALYSIS");
        logger.println("");
    }

    private Graph<Propagator> buildPropagatorOrientedGraph(boolean withWeight) {
        Node.ID = 0;
        Propagator[] propagators = (Propagator[])Arrays.stream(this.model.getCstrs()).map(Constraint::getPropagators).flatMap(Arrays::stream).distinct().toArray(Propagator[]::new);
        Graph<Propagator> graph = new Graph<Propagator>();
        for (Propagator prop : propagators) {
            Node<Propagator> node = new Node<Propagator>(prop);
            graph.nodes.add(node);
            graph.mapObjToNodes.put(prop, node);
        }
        for (int i = 0; i < propagators.length; ++i) {
            int finali = i;
            for (int j = i + 1; j < propagators.length; ++j) {
                int nbCommonVars = 0;
                for (int k = 0; k < propagators[i].getNbVars(); ++k) {
                    int finalk = k;
                    boolean commonVar = Arrays.stream(propagators[j].getVars()).filter(Objects::nonNull).anyMatch(v -> v.equals(propagators[finali].getVar(finalk)));
                    if (!commonVar) continue;
                    ++nbCommonVars;
                }
                if (nbCommonVars <= 0) continue;
                Node nodei = graph.mapObjToNodes.get(propagators[i]);
                Node nodej = graph.mapObjToNodes.get(propagators[j]);
                nodei.neighbors.put(nodej, withWeight ? nbCommonVars : 1);
                nodej.neighbors.put(nodei, withWeight ? nbCommonVars : 1);
            }
        }
        return graph;
    }

    private <T> void writeGraph(Graph<T> graph, String orientation, String path) {
        Path instance = Paths.get(path, new String[0]);
        if (Files.exists(instance, new LinkOption[0])) {
            try {
                Files.delete(instance);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            Files.createFile(instance, new FileAttribute[0]);
            Files.write(instance, ((Graph)graph).buildGvString().getBytes(), StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            System.err.println("Could not write " + orientation + "-oriented graph");
        }
    }

    public void writePropagatorOrientedGraph(String path) {
        this.writePropagatorOrientedGraph(path, true);
    }

    public void writePropagatorOrientedGraph(String path, boolean withWeight) {
        Graph<Propagator> graph = this.buildPropagatorOrientedGraph(withWeight);
        this.writeGraph(graph, "propagator", path);
    }

    private Graph<Variable> buildVariableOrientedGraph(boolean withWeight) {
        Propagator[] propagators;
        Node.ID = 0;
        Variable[] variables = (Variable[])Arrays.stream(this.model.getVars()).distinct().toArray(Variable[]::new);
        Graph<Variable> graph = new Graph<Variable>();
        for (Variable var : variables) {
            Node<Variable> node = new Node<Variable>(var);
            graph.nodes.add(node);
            graph.mapObjToNodes.put(var, node);
        }
        HashMap mapVarProps = new HashMap();
        for (Propagator prop : propagators = (Propagator[])Arrays.stream(this.model.getCstrs()).map(Constraint::getPropagators).flatMap(Arrays::stream).distinct().toArray(Propagator[]::new)) {
            for (Variable var : prop.getVars()) {
                if (!mapVarProps.containsKey(var)) {
                    mapVarProps.put(var, new HashSet());
                }
                ((Set)mapVarProps.get(var)).add(prop);
            }
        }
        for (int i = 0; i < variables.length; ++i) {
            if (!mapVarProps.containsKey(variables[i])) continue;
            for (int j = i + 1; j < variables.length; ++j) {
                int nbCommonPropagators;
                if (!mapVarProps.containsKey(variables[j]) || (nbCommonPropagators = (int)((Set)mapVarProps.get(variables[i])).stream().filter(Objects::nonNull).filter(((Set)mapVarProps.get(variables[j]))::contains).count()) <= 0) continue;
                Node nodei = graph.mapObjToNodes.get(variables[i]);
                Node nodej = graph.mapObjToNodes.get(variables[j]);
                nodei.neighbors.put(nodej, withWeight ? nbCommonPropagators : 1);
                nodej.neighbors.put(nodei, withWeight ? nbCommonPropagators : 1);
            }
        }
        return graph;
    }

    public void writeVariableOrientedGraph(String path) {
        this.writeVariableOrientedGraph(path, true);
    }

    public void writeVariableOrientedGraph(String path, boolean withWeight) {
        Graph<Variable> graph = this.buildVariableOrientedGraph(withWeight);
        this.writeGraph(graph, "variable", path);
    }

    public static class VariableTypeStatistics {
        public final String varType;
        public final String classVarType;
        public final int nbVariables;
        public final int nbInstantiatedVariables;
        public final LinkedHashMap<String, Integer> byDomainSize;
        public final Map<Integer, Integer> byNbPropagators;
        public final Map<Integer, Integer> byNbViews;

        private VariableTypeStatistics(String varType, String classVarType, int nbVariables, int nbInstantiatedVariables, LinkedHashMap<String, Integer> byDomainSize, Map<Integer, Integer> byNbPropagators, Map<Integer, Integer> byNbViews) {
            this.varType = varType;
            this.classVarType = classVarType;
            this.nbVariables = nbVariables;
            this.nbInstantiatedVariables = nbInstantiatedVariables;
            this.byDomainSize = byDomainSize;
            this.byNbPropagators = byNbPropagators;
            this.byNbViews = byNbViews;
        }

        public String toString() {
            return this.toString(false, true, false);
        }

        public String toString(boolean addInitialTab, boolean addVarType, boolean printAllStats) {
            StringBuilder sb = new StringBuilder(addInitialTab ? "\t" : "");
            if (addVarType) {
                sb.append(this.varType).append(".");
            }
            sb.append(this.classVarType).append(" = ").append(this.nbVariables).append("\n");
            if (printAllStats || this.nbInstantiatedVariables > 0) {
                sb.append(addInitialTab ? "\t" : "");
                sb.append("\t- Nb instantiated: ").append(this.nbInstantiatedVariables).append("\n");
            }
            if (printAllStats || this.byNbPropagators.containsKey(0)) {
                sb.append(addInitialTab ? "\t" : "");
                int nbUnconstrained = this.byNbPropagators.getOrDefault(0, 0);
                sb.append("\t- Nb unconstrained: ").append(nbUnconstrained).append("\n");
            }
            sb.append(addInitialTab ? "\t" : "");
            sb.append("\t- By domain size: ").append(ModelAnalyser.prettyObjSizeMap(this.byDomainSize));
            if (printAllStats || this.byNbPropagators.keySet().size() != 1 || !this.byNbPropagators.containsKey(0)) {
                sb.append("\n");
                sb.append(addInitialTab ? "\t" : "");
                sb.append("\t- By number of propagators: ").append(ModelAnalyser.prettyIntSizeMap(this.byNbPropagators));
            }
            if (printAllStats || this.byNbViews.keySet().size() != 1 || !this.byNbViews.containsKey(0)) {
                sb.append("\n");
                sb.append(addInitialTab ? "\t" : "");
                sb.append("\t- By number of views: ").append(ModelAnalyser.prettyIntSizeMap(this.byNbViews));
            }
            return sb.toString();
        }

        private static VariableTypeStatistics createVariableTypeStatistics(Map<String, Map<String, List<Variable>>> mapTypeClassNbVars, String varType, String classNameOfType) {
            return VariableTypeStatistics.createVariableTypeStatistics(mapTypeClassNbVars, varType, classNameOfType, true);
        }

        private static VariableTypeStatistics createVariableTypeStatistics(Map<String, Map<String, List<Variable>>> mapTypeClassNbVars, String varType, String classNameOfType, boolean showByRange) {
            List<Object> list = mapTypeClassNbVars.containsKey(varType) && mapTypeClassNbVars.get(varType).containsKey(classNameOfType) ? mapTypeClassNbVars.get(varType).get(classNameOfType) : new ArrayList();
            int nbVariables = list.size();
            int nbInstantiatedVariables = (int)list.stream().filter(Variable::isInstantiated).count();
            LinkedHashMap<String, Integer> byDomainSize = new LinkedHashMap<String, Integer>();
            Map<Integer, List<Variable>> byDomainIntSize = Collections.unmodifiableMap(new LinkedHashMap<Integer, List<Variable>>(list.stream().collect(Collectors.groupingBy(Variable::getDomainSize))));
            if (showByRange) {
                int[] domainRangeLb = new int[]{1, 2, 3, 4, 10, 101, 1001};
                Object domainRangeUb = new int[]{1, 2, 3, 9, 100, 1000, Integer.MAX_VALUE};
                for (int i = 0; i < domainRangeLb.length; ++i) {
                    int rangeLb = domainRangeLb[i];
                    Object rangeUb = domainRangeUb[i];
                    String domainRangeName = rangeUb == Integer.MAX_VALUE ? ">" + rangeLb : (rangeLb == rangeUb ? Integer.toString(rangeLb) : rangeLb + "-" + (int)rangeUb);
                    List vars = byDomainIntSize.entrySet().stream().filter(arg_0 -> VariableTypeStatistics.lambda$createVariableTypeStatistics$0(rangeLb, (int)rangeUb, arg_0)).map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toList());
                    if (vars.isEmpty()) continue;
                    byDomainSize.put(domainRangeName, vars.size());
                }
            } else {
                List domainSize = byDomainIntSize.keySet().stream().sorted().collect(Collectors.toList());
                for (Integer size : domainSize) {
                    if (byDomainIntSize.get(size).isEmpty()) continue;
                    byDomainSize.put(size.toString(), byDomainIntSize.get(size).size());
                }
            }
            Map<Integer, List<Variable>> byNbPropagatorsList = Collections.unmodifiableMap(new LinkedHashMap<Integer, List<Variable>>(list.stream().collect(Collectors.groupingBy(Variable::getNbProps))));
            LinkedHashMap<Integer, Integer> byNbPropagators = new LinkedHashMap<Integer, Integer>();
            List nbPropsList = byNbPropagatorsList.keySet().stream().sorted().collect(Collectors.toList());
            for (Integer nbProps : nbPropsList) {
                if (byNbPropagatorsList.get(nbProps).isEmpty()) continue;
                byNbPropagators.put(nbProps, byNbPropagatorsList.get(nbProps).size());
            }
            Map<Integer, List<Variable>> byNbViewsList = Collections.unmodifiableMap(new LinkedHashMap<Integer, List<Variable>>(list.stream().collect(Collectors.groupingBy(Variable::getNbViews))));
            LinkedHashMap<Integer, Integer> byNbViews = new LinkedHashMap<Integer, Integer>();
            List nbViewsList = byNbViewsList.keySet().stream().sorted().collect(Collectors.toList());
            for (Integer nbViews : nbViewsList) {
                if (byNbViewsList.get(nbViews).isEmpty()) continue;
                byNbViews.put(nbViews, byNbViewsList.get(nbViews).size());
            }
            return new VariableTypeStatistics(varType, classNameOfType, nbVariables, nbInstantiatedVariables, byDomainSize, byNbPropagators, byNbViews);
        }

        private static /* synthetic */ boolean lambda$createVariableTypeStatistics$0(int rangeLb, int rangeUb, Map.Entry entry) {
            return rangeLb <= (Integer)entry.getKey() && (Integer)entry.getKey() <= rangeUb;
        }
    }

    public static class ConstraintTypeStatistics {
        public final String cstrType;
        public final String propType;
        public final int nbPropagators;
        public final int nbEntailedPropagators;
        public final int nbPassivePropagators;
        public final int nbCompletelyInstantiatedPropagators;
        public final int nbReifiedPropagators;
        public final Map<Integer, Integer> byNbVariables;
        public final Map<Integer, Integer> byArity;

        private ConstraintTypeStatistics(String cstrType, String propType, int nbPropagators, int nbEntailedPropagators, int nbPassivePropagators, int nbCompletelyInstantiatedPropagators, int nbReifiedPropagators, Map<Integer, Integer> byNbVariables, Map<Integer, Integer> byArity) {
            this.cstrType = cstrType;
            this.propType = propType;
            this.nbPropagators = nbPropagators;
            this.nbEntailedPropagators = nbEntailedPropagators;
            this.nbPassivePropagators = nbPassivePropagators;
            this.nbCompletelyInstantiatedPropagators = nbCompletelyInstantiatedPropagators;
            this.nbReifiedPropagators = nbReifiedPropagators;
            this.byNbVariables = byNbVariables;
            this.byArity = byArity;
        }

        public String toString() {
            return this.toString(false, true, false);
        }

        public String toString(boolean addInitialTab, boolean addCstrType, boolean printAllStats) {
            StringBuilder sb = new StringBuilder(addInitialTab ? "\t" : "");
            if (addCstrType) {
                sb.append(this.cstrType).append(".");
            }
            sb.append(this.propType).append(" = ").append(this.nbPropagators).append("\n");
            if (printAllStats || this.nbEntailedPropagators > 0) {
                sb.append(addInitialTab ? "\t" : "");
                sb.append("\t- Nb entailed: ").append(this.nbEntailedPropagators).append("\n");
            }
            if (printAllStats || this.nbPassivePropagators > 0) {
                sb.append(addInitialTab ? "\t" : "");
                sb.append("\t- Nb passive: ").append(this.nbPassivePropagators).append("\n");
            }
            if (printAllStats || this.nbCompletelyInstantiatedPropagators > 0) {
                sb.append(addInitialTab ? "\t" : "");
                sb.append("\t- Nb completely instantiated: ").append(this.nbCompletelyInstantiatedPropagators).append("\n");
            }
            if (printAllStats || this.nbReifiedPropagators > 0) {
                sb.append(addInitialTab ? "\t" : "");
                sb.append("\t- Nb reified: ").append(this.nbReifiedPropagators).append("\n");
            }
            sb.append(addInitialTab ? "\t" : "");
            sb.append("\t- By number of variables: ").append(ModelAnalyser.prettyIntSizeMap(this.byNbVariables)).append("\n");
            sb.append(addInitialTab ? "\t" : "");
            sb.append("\t- By arity: ").append(ModelAnalyser.prettyIntSizeMap(this.byArity));
            return sb.toString();
        }

        private static ConstraintTypeStatistics createConstraintTypeStatistics(Map<String, Map<String, List<Propagator>>> mapTypeClassNbCstrs, String cstrType, String classNameOfType) {
            List<Object> list = mapTypeClassNbCstrs.containsKey(cstrType) && mapTypeClassNbCstrs.get(cstrType).containsKey(classNameOfType) ? mapTypeClassNbCstrs.get(cstrType).get(classNameOfType) : new ArrayList();
            int nbPropagators = list.size();
            int nbEntailedPropagators = (int)list.stream().filter(p -> p.isEntailed().equals((Object)ESat.TRUE)).count();
            int nbPassivePropagators = (int)list.stream().filter(Propagator::isPassive).count();
            int nbCompletelyInstantiatedPropagators = (int)list.stream().filter(Propagator::isCompletelyInstantiated).count();
            int nbReifiedPropagators = (int)list.stream().filter(Propagator::isReified).count();
            Map<Integer, List<Propagator>> byNbVarsList = list.stream().collect(Collectors.groupingBy(Propagator::arity));
            LinkedHashMap<Integer, Integer> byNbVars = new LinkedHashMap<Integer, Integer>();
            List nbVarsList = byNbVarsList.keySet().stream().sorted().collect(Collectors.toList());
            for (Integer nbVars : nbVarsList) {
                if (byNbVarsList.get(nbVars).isEmpty()) continue;
                byNbVars.put(nbVars, byNbVarsList.get(nbVars).size());
            }
            Map<Integer, List<Propagator>> byArityList = list.stream().collect(Collectors.groupingBy(Propagator::arity));
            LinkedHashMap<Integer, Integer> byArity = new LinkedHashMap<Integer, Integer>();
            List arityList = byArityList.keySet().stream().sorted().collect(Collectors.toList());
            for (Integer arity : arityList) {
                if (byArityList.get(arity).isEmpty()) continue;
                byArity.put(arity, byArityList.get(arity).size());
            }
            return new ConstraintTypeStatistics(cstrType, classNameOfType, nbPropagators, nbEntailedPropagators, nbPassivePropagators, nbCompletelyInstantiatedPropagators, nbReifiedPropagators, byNbVars, byArity);
        }
    }

    public static class ModelAnalysis {
        public final VariableTypeStatistics[] varsTypeStats;
        public final ConstraintTypeStatistics[] cstrsTypeStats;

        public ModelAnalysis(VariableTypeStatistics[] varsTypeStats, ConstraintTypeStatistics[] cstrsTypeStats) {
            this.varsTypeStats = varsTypeStats;
            this.cstrsTypeStats = cstrsTypeStats;
        }
    }

    private static class Node<T> {
        private static int ID = 0;
        public final int id;
        public final T obj;
        public final Map<Node<T>, Integer> neighbors = new HashMap<Node<T>, Integer>();

        public Node(T t) {
            this.id = ID++;
            this.obj = t;
        }
    }

    private static class Graph<T> {
        public final List<Node<T>> nodes = new ArrayList<Node<T>>();
        public final Map<T, Node<T>> mapObjToNodes = new HashMap<T, Node<T>>();
        private static final String NODE = "\t%d [label = \"%s\" shape = circle];\n";
        private static final String EDGE = "\t%d -- %d [weight = %d];\n";

        private Graph() {
        }

        private String buildGvString() {
            StringBuilder sb = new StringBuilder("graph G{\n");
            sb.append("\trankdir=TB;\n\n");
            for (Node<T> node : this.nodes) {
                if (node.obj instanceof Variable) {
                    Variable var = (Variable)node.obj;
                    sb.append(String.format(NODE, node.id, var.getName()));
                    continue;
                }
                Propagator prop = (Propagator)node.obj;
                sb.append(String.format(NODE, node.id, ModelAnalyser.getClassName(prop.getClass()) + "-" + prop.getId()));
            }
            sb.append("\n\n");
            HashSet<Integer> edgesSet = new HashSet<Integer>();
            for (int i = 0; i < this.nodes.size(); ++i) {
                Node<T> nodei = this.nodes.get(i);
                for (Map.Entry entry : nodei.neighbors.entrySet()) {
                    Node nodej = entry.getKey();
                    Integer pair1 = nodei.id * Node.ID + nodej.id;
                    Integer pair2 = nodej.id * Node.ID + nodei.id;
                    if (edgesSet.contains(pair1) || edgesSet.contains(pair2)) continue;
                    edgesSet.add(pair1);
                    sb.append(String.format(EDGE, nodei.id, nodej.id, entry.getValue()));
                }
            }
            sb.append("}");
            return sb.toString();
        }
    }
}

