## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(retroharmonize)

## -----------------------------------------------------------------------------
sl1 <- labelled_spss_survey (
  x = c(1,1,0,8,8,8), 
  labels = c("yes" =1,
             "no" = 0,
             "declined" = 8),
  label = "Do you agree?",
  na_values = 8, 
  id = "survey1")

print(sl1)

## -----------------------------------------------------------------------------
is.labelled_spss_survey (sl1)

## -----------------------------------------------------------------------------
haven::is.labelled(sl1)

## -----------------------------------------------------------------------------
labelled::val_labels(sl1)

## -----------------------------------------------------------------------------
labelled::na_values(sl1)

## -----------------------------------------------------------------------------
sl1[3:4]

## -----------------------------------------------------------------------------
df <- tibble::tibble (v1 = sl1)
## Use tibble instead of data.frame(v1=sl1) ...
print(df)
## ... which inherits the methods of a data.frame 
subset(df, v1 == 1)

## -----------------------------------------------------------------------------
#double
c(sl1, 1/7)
vctrs::vec_c(sl1, 1/7)

## ----integer------------------------------------------------------------------
c(sl1, 1:3)

## ----character----------------------------------------------------------------
as.character(sl1)

## ----as.factor----------------------------------------------------------------
as.factor(sl1)

## ----as_factor----------------------------------------------------------------
as_factor(sl1)

## ----numerics-----------------------------------------------------------------
as.numeric(sl1)
as_numeric(sl1)

## -----------------------------------------------------------------------------
median (as.numeric(sl1))
median (sl1)

## -----------------------------------------------------------------------------
quantile (as.numeric(sl1), 0.9)
quantile (sl1, 0.9)

## -----------------------------------------------------------------------------
mean (as.numeric(sl1))
mean (sl1)
mean (sl1, na.rm=TRUE)

## -----------------------------------------------------------------------------
weights1 <- runif (n = 6, min = 0, max = 1)
weighted.mean(as.numeric(sl1), weights1)
weighted.mean(sl1, weights1)

## -----------------------------------------------------------------------------
sum (as.numeric(sl1))
sum (sl1, na.rm=TRUE)

## -----------------------------------------------------------------------------
as_numeric(sl1)
min ( as_numeric(sl1))
min ( as_numeric(sl1), na.rm=TRUE)

