/*
 * Decompiled with CFR 0.152.
 */
package dmLab.mcfs.cutoffMethods;

import dmLab.mcfs.MCFSParams;
import dmLab.mcfs.attributesRI.AttributesRI;
import dmLab.mcfs.attributesRI.measuresRI.Importance;
import dmLab.mcfs.cutoffMethods.ContrastCutoff;
import dmLab.mcfs.cutoffMethods.CriticalAngleCutoff;
import dmLab.mcfs.cutoffMethods.CutoffMethod;
import dmLab.mcfs.cutoffMethods.KMeansCutoff;
import dmLab.utils.ArrayUtils;
import dmLab.utils.MathUtils;
import dmLab.utils.dataframe.DataFrame;
import java.util.Arrays;

public final class Cutoff {
    private CutoffMethod[] cutoffMethod;
    private DataFrame cutoffTable;
    private MCFSParams mcfsParams;

    /*
     * WARNING - void declaration
     */
    public Cutoff(MCFSParams mcfsParams) {
        void var1_1;
        void var2_2;
        int methodsNum = this.initCutoffMethods(mcfsParams);
        this.cutoffTable = new DataFrame((int)var2_2, 4);
        this.cutoffTable.setColNames(new String[]{"method", "minRI", "size", "minID"});
        this.cutoffTable.setColTypes(new short[]{0, 1, 1, 1});
        this.mcfsParams = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private int initCutoffMethods(MCFSParams mcfsParams) {
        if (mcfsParams.cutoffMethod.equalsIgnoreCase("contrast")) {
            this.cutoffMethod = new CutoffMethod[3];
            this.cutoffMethod[0] = new CriticalAngleCutoff(mcfsParams);
            this.cutoffMethod[1] = new KMeansCutoff(mcfsParams);
            this.cutoffMethod[2] = new ContrastCutoff(mcfsParams);
        } else {
            void var1_1;
            this.cutoffMethod = new CutoffMethod[2];
            this.cutoffMethod[0] = new CriticalAngleCutoff(mcfsParams);
            this.cutoffMethod[1] = new KMeansCutoff((MCFSParams)var1_1);
        }
        return this.cutoffMethod.length;
    }

    /*
     * WARNING - void declaration
     */
    public final double calcCutoff(AttributesRI attrRI) {
        void var1_1;
        Cutoff cutoff = this;
        int methodsNum = cutoff.initCutoffMethods(cutoff.mcfsParams);
        AttributesRI attributesRI = attrRI;
        Object[] importance = attributesRI.getImportances(attributesRI.mainMeasureIdx);
        Arrays.sort(importance);
        double[] minRI = new double[methodsNum];
        double[] attrNumber = new double[methodsNum];
        for (int i = 0; i < this.cutoffMethod.length; ++i) {
            double d;
            block2: {
                minRI[i] = this.cutoffMethod[i].getCutoff((Importance[])importance);
                double d2 = minRI[i];
                Object[] objectArray = importance;
                for (int j = 0; j < objectArray.length; ++j) {
                    if (!(((Importance)objectArray[j]).importance <= d2)) continue;
                    d = j + 1;
                    break block2;
                }
                d = Double.NaN;
            }
            attrNumber[i] = d;
            DataFrame dataFrame = this.cutoffTable;
            dataFrame.set(i, dataFrame.getColIdx("method"), this.cutoffMethod[i].name);
            DataFrame dataFrame2 = this.cutoffTable;
            dataFrame2.set(i, dataFrame2.getColIdx("minRI"), minRI[i]);
            DataFrame dataFrame3 = this.cutoffTable;
            dataFrame3.set(i, dataFrame3.getColIdx("size"), attrNumber[i]);
        }
        double d = this.addMeanValue((AttributesRI)var1_1);
        return d;
    }

    /*
     * WARNING - void declaration
     */
    public final double addMeanValue(AttributesRI attrRI) {
        void var1_1;
        AttributesRI attributesRI = attrRI;
        Object[] importance = attributesRI.getImportances(attributesRI.mainMeasureIdx);
        Arrays.sort(importance);
        double[] dArray = ArrayUtils.Double2double(this.cutoffTable.getColumn(this.cutoffTable.getColIdx("size")));
        double mean_attrNumber = Math.round(MathUtils.mean(dArray));
        double mean_minRI = ((Importance)importance[(int)mean_attrNumber]).importance;
        DataFrame meanRow = new DataFrame(1, this.cutoffTable);
        meanRow.set(0, meanRow.getColIdx("method"), "mean");
        meanRow.set(0, meanRow.getColIdx("minRI"), mean_minRI);
        meanRow.set(0, meanRow.getColIdx("size"), mean_attrNumber);
        this.cutoffTable.rbind((DataFrame)var1_1);
        return mean_minRI;
    }

    public final DataFrame getCutoffTable() {
        return this.cutoffTable;
    }

    /*
     * WARNING - void declaration
     */
    public final void setCutoffTable(DataFrame cutoffTable) {
        void var1_1;
        this.cutoffTable = var1_1;
    }

    public final String toString() {
        return this.cutoffTable.toString();
    }

    /*
     * WARNING - void declaration
     */
    public final float getCutoffValue(String method) {
        void var1_2;
        void var2_4;
        int colIdx = this.cutoffTable.getColIdx("method");
        int rowIdx = this.cutoffTable.getFirstRowIdx((int)var2_4, this.getMethod(method));
        DataFrame dataFrame = this.cutoffTable;
        float f = ((Double)dataFrame.get((int)var1_2, dataFrame.getColIdx("size"))).floatValue();
        return f;
    }

    /*
     * WARNING - void declaration
     */
    public final String getMethod(String method) {
        void var1_1;
        void var2_2;
        int colIdx = this.cutoffTable.getColIdx("method");
        int rowIdx = this.cutoffTable.getFirstRowIdx(colIdx, method);
        if (var2_2 == -1) {
            String resultMethod = "mean";
        }
        return var1_1;
    }
}

