## ----setup, include = FALSE-------------------------------------------------------------------------------------------------------------------------
options(width = 150)
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.align = "center", fig.width = 7,
  out.width = "80%"
)

## ----package----------------------------------------------------------------------------------------------------------------------------------------
library(rsimsum)

## ----data-------------------------------------------------------------------------------------------------------------------------------------------
data("nlp", package = "rsimsum")

## ----display-data-----------------------------------------------------------------------------------------------------------------------------------
head(nlp)

## ----analyse----------------------------------------------------------------------------------------------------------------------------------------
s <- rsimsum::simsum(
  data = nlp, estvarname = "b", true = 0, se = "se",
  methodvar = "model", by = c("baseline", "ss", "esigma")
)
s

## ----nlp, fig.asp = 0.75----------------------------------------------------------------------------------------------------------------------------
library(ggplot2)
autoplot(s, type = "nlp", stats = "bias")

