## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(stratcols)

## -----------------------------------------------------------------------------
thickness = runif(10) #bed thicknesses
facies = rep(c(1,2), 5) # facies codes

s = as_stratcol(thickness = thickness,
                facies = facies)

## -----------------------------------------------------------------------------
is_stratcol(s)

## -----------------------------------------------------------------------------
bed_thickness(s)


## -----------------------------------------------------------------------------
facies_names(s)
unique_facies_names(s)

## -----------------------------------------------------------------------------
no_beds(s) # number of beds
no_facies(s) # number of distinct facies.

total_thickness(s) # total thickness of column

get_base(s) # lowest bed boundary
get_L_unit(s) # length unit of beds

facies_repetitions(s) # do at least two successive beds have identical facies?
merge_beds(s, mode = "identical facies") # merge successive beds with identical facies

## ----fig.alt="Stratigraphic column"-------------------------------------------
plot(s)

## ----fig.alt="stratigraphic column with changed facies codes"-----------------
s2 = rename_facies(s, new_names = c(2,3))
plot(s2)

## -----------------------------------------------------------------------------
s3 = set_L_unit(s, "m")
get_L_unit(s3)

## ----eval=FALSE---------------------------------------------------------------
# vignette("stratcols_doc")

## ----eval=FALSE---------------------------------------------------------------
# vignette("stratorder")

