/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.speciation;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evolution.tree.TreeTraitProvider;
import dr.evolution.util.Units;
import dr.evomodel.speciation.UltrametricSpeciationModel;
import dr.evomodel.tree.DefaultTreeModel;
import dr.evomodel.tree.TreeModel;
import dr.evomodel.tree.randomlocalmodel.RandomLocalTreeVariable;
import dr.inference.model.Parameter;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RandomLocalYuleModel
extends UltrametricSpeciationModel
implements TreeTraitProvider,
RandomLocalTreeVariable {
    private boolean calculateAllBirthRates = false;
    protected TreeTraitProvider.Helper treeTraits = new TreeTraitProvider.Helper();
    private double[] birthRates;
    private String birthRatesName = "birthRates";
    private String indicatorsName = "birthRateIndicator";
    private Parameter meanRate;
    private boolean birthRatesAreMultipliers = false;
    private NumberFormat format = NumberFormat.getNumberInstance(Locale.ENGLISH);

    public RandomLocalYuleModel(Parameter parameter, Parameter parameter2, Parameter parameter3, boolean bl, Units.Type type, int n) {
        super("randomLocalYuleModel", type);
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, parameter.getDimension()));
        for (int i = 0; i < parameter2.getDimension(); ++i) {
            parameter2.setParameterValueQuietly(i, 0.0);
        }
        this.addVariable(parameter2);
        this.meanRate = parameter3;
        this.addVariable(parameter3);
        this.birthRatesAreMultipliers = bl;
        this.format.setMaximumFractionDigits(n);
        this.birthRatesName = parameter.getParameterName();
        Logger.getLogger("dr.evomodel").info("  birth rates parameter is named '" + this.birthRatesName + "'");
        this.indicatorsName = parameter2.getParameterName();
        Logger.getLogger("dr.evomodel").info("  indicator parameter is named '" + this.indicatorsName + "'");
        this.birthRates = new double[parameter.getDimension() + 1];
        this.treeTraits.addTrait(new TreeTrait.I(){

            @Override
            public String getTraitName() {
                return "I";
            }

            @Override
            public TreeTrait.Intent getIntent() {
                return TreeTrait.Intent.NODE;
            }

            @Override
            public Integer getTrait(Tree tree, NodeRef nodeRef) {
                return RandomLocalYuleModel.this.isVariableSelected(tree, nodeRef) ? 1 : 0;
            }
        });
        this.treeTraits.addTrait(new TreeTrait.D(){

            @Override
            public String getTraitName() {
                return "b";
            }

            @Override
            public TreeTrait.Intent getIntent() {
                return TreeTrait.Intent.NODE;
            }

            @Override
            public Double getTrait(Tree tree, NodeRef nodeRef) {
                return RandomLocalYuleModel.this.birthRates[nodeRef.getNumber()];
            }
        });
    }

    @Override
    public final double getVariable(Tree tree, NodeRef nodeRef) {
        return ((DefaultTreeModel)tree).getNodeTrait(nodeRef, this.birthRatesName);
    }

    @Override
    public final boolean isVariableSelected(Tree tree, NodeRef nodeRef) {
        return ((DefaultTreeModel)tree).getNodeTrait(nodeRef, this.indicatorsName) > 0.5;
    }

    @Override
    public final double logTreeProbability(int n) {
        this.calculateAllBirthRates = true;
        return 0.0;
    }

    @Override
    public final double logNodeProbability(Tree tree, NodeRef nodeRef) {
        if (this.calculateAllBirthRates) {
            this.calculateBirthRates((TreeModel)tree, tree.getRoot(), 0.0);
            this.calculateAllBirthRates = false;
        }
        if (tree.isRoot(nodeRef)) {
            return 0.0;
        }
        double d = this.birthRates[nodeRef.getNumber()];
        double d2 = tree.getNodeHeight(tree.getParent(nodeRef)) - tree.getNodeHeight(nodeRef);
        double d3 = -d * d2;
        if (tree.isExternal(nodeRef)) {
            d3 += Math.log(d);
        }
        return d3;
    }

    private void calculateBirthRates(TreeModel treeModel, NodeRef nodeRef, double d) {
        int n = nodeRef.getNumber();
        if (treeModel.isRoot(nodeRef)) {
            d = this.meanRate.getParameterValue(0);
        } else if (this.isVariableSelected(treeModel, nodeRef)) {
            d = this.birthRatesAreMultipliers ? (d *= this.getVariable(treeModel, nodeRef)) : this.getVariable(treeModel, nodeRef);
        }
        this.birthRates[n] = d;
        int n2 = treeModel.getChildCount(nodeRef);
        for (int i = 0; i < n2; ++i) {
            this.calculateBirthRates(treeModel, treeModel.getChild(nodeRef, i), d);
        }
    }

    @Override
    public TreeTrait[] getTreeTraits() {
        return this.treeTraits.getTreeTraits();
    }

    @Override
    public TreeTrait getTreeTrait(String string) {
        return this.treeTraits.getTreeTrait(string);
    }

    @Override
    public boolean includeExternalNodesInLikelihoodCalculation() {
        return true;
    }

    @Override
    public Element createElement(Document document) {
        throw new RuntimeException("createElement not implemented");
    }
}

