/*
 * Decompiled with CFR 0.152.
 */
package dr.xml;

import dr.xml.ClassComparator;
import dr.xml.XMLDocumentationHandler;
import dr.xml.XMLObject;
import dr.xml.XMLSyntaxRule;
import java.util.Set;
import java.util.TreeSet;

public class XORRule
implements XMLSyntaxRule {
    private final XMLSyntaxRule[] rules;
    private final boolean optional;

    public XORRule(XMLSyntaxRule xMLSyntaxRule, XMLSyntaxRule xMLSyntaxRule2) {
        this(xMLSyntaxRule, xMLSyntaxRule2, false);
    }

    public XORRule(XMLSyntaxRule[] xMLSyntaxRuleArray) {
        this(xMLSyntaxRuleArray, false);
    }

    public XORRule(XMLSyntaxRule xMLSyntaxRule, XMLSyntaxRule xMLSyntaxRule2, boolean bl) {
        this(new XMLSyntaxRule[]{xMLSyntaxRule, xMLSyntaxRule2}, bl);
    }

    public XORRule(XMLSyntaxRule[] xMLSyntaxRuleArray, boolean bl) {
        this.rules = xMLSyntaxRuleArray;
        this.optional = bl;
    }

    public XMLSyntaxRule[] getRules() {
        return this.rules;
    }

    @Override
    public boolean isSatisfied(XMLObject xMLObject) {
        int n = 0;
        for (XMLSyntaxRule xMLSyntaxRule : this.rules) {
            if (!xMLSyntaxRule.isSatisfied(xMLObject) || ++n <= 1) continue;
            return false;
        }
        return this.optional || n == 1;
    }

    @Override
    public boolean containsAttribute(String string) {
        for (XMLSyntaxRule xMLSyntaxRule : this.rules) {
            if (!xMLSyntaxRule.containsAttribute(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String ruleString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.optional) {
            stringBuffer.append("*Optionally, one of \n");
        } else {
            stringBuffer.append("*One of \n");
        }
        for (XMLSyntaxRule xMLSyntaxRule : this.rules) {
            stringBuffer.append("*").append(xMLSyntaxRule.ruleString()).append("\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public String htmlRuleString(XMLDocumentationHandler xMLDocumentationHandler) {
        StringBuffer stringBuffer = new StringBuffer("<div class=\"requiredcompoundrule\">One of:\n");
        for (XMLSyntaxRule xMLSyntaxRule : this.rules) {
            stringBuffer.append(xMLSyntaxRule.htmlRuleString(xMLDocumentationHandler));
        }
        stringBuffer.append("</div>\n");
        return stringBuffer.toString();
    }

    @Override
    public String wikiRuleString(XMLDocumentationHandler xMLDocumentationHandler, String string) {
        StringBuffer stringBuffer = new StringBuffer(string + "One of:\n");
        for (XMLSyntaxRule xMLSyntaxRule : this.rules) {
            stringBuffer.append(xMLSyntaxRule.wikiRuleString(xMLDocumentationHandler, string + "*"));
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    @Override
    public String markdownRuleString(XMLDocumentationHandler xMLDocumentationHandler, String string) {
        StringBuffer stringBuffer = new StringBuffer(string + "One of:\n");
        for (XMLSyntaxRule xMLSyntaxRule : this.rules) {
            stringBuffer.append(xMLSyntaxRule.markdownRuleString(xMLDocumentationHandler, string + "    "));
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    @Override
    public String ruleString(XMLObject xMLObject) {
        return this.ruleString();
    }

    @Override
    public Set<Class> getRequiredTypes() {
        TreeSet<Class> treeSet = new TreeSet<Class>(ClassComparator.INSTANCE);
        for (XMLSyntaxRule xMLSyntaxRule : this.rules) {
            treeSet.addAll(xMLSyntaxRule.getRequiredTypes());
        }
        return treeSet;
    }

    @Override
    public boolean isLegalElementName(String string) {
        for (XMLSyntaxRule xMLSyntaxRule : this.rules) {
            if (!xMLSyntaxRule.isLegalElementName(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isLegalElementClass(Class clazz) {
        for (XMLSyntaxRule xMLSyntaxRule : this.rules) {
            if (!xMLSyntaxRule.isLegalElementClass(clazz)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isLegalSubelementName(String string) {
        for (XMLSyntaxRule xMLSyntaxRule : this.rules) {
            if (!xMLSyntaxRule.isLegalSubelementName(string)) continue;
            return true;
        }
        return false;
    }
}

