/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.distances;

import jebl.evolution.alignments.Alignment;
import jebl.evolution.alignments.Pattern;
import jebl.evolution.distances.BasicDistanceMatrix;
import jebl.evolution.distances.CannotBuildDistanceMatrixException;
import jebl.evolution.distances.ModelBasedDistanceMatrix;
import jebl.evolution.sequences.Nucleotides;
import jebl.evolution.sequences.State;
import jebl.util.ProgressListener;

public class HKYDistanceMatrix
extends BasicDistanceMatrix {
    public HKYDistanceMatrix(Alignment alignment, ProgressListener progress, boolean useTwiceMaximumDistanceWhenPairwiseDistanceNotCalculatable) throws CannotBuildDistanceMatrixException {
        super(alignment.getTaxa(), new Initializer().getDistances(alignment, progress, useTwiceMaximumDistanceWhenPairwiseDistanceNotCalculatable));
    }

    public HKYDistanceMatrix(Alignment alignment, ProgressListener progress) throws CannotBuildDistanceMatrixException {
        this(alignment, progress, false);
    }

    static class Initializer
    extends ModelBasedDistanceMatrix
    implements BasicDistanceMatrix.PairwiseDistanceCalculator {
        private Alignment alignment;
        private double constA;
        private double constB;
        private double constC;

        Initializer() {
        }

        public double calculatePairwiseDistance(int taxon1, int taxon2) throws CannotBuildDistanceMatrixException {
            block9: {
                double Q;
                double P;
                double a;
                double sumTs = 0.0;
                double sumTv = 0.0;
                double sumWeight = 0.0;
                boolean noGapsPairFound = false;
                for (Pattern pattern : this.alignment.getPatterns()) {
                    State state1 = pattern.getState(taxon1);
                    State state2 = pattern.getState(taxon2);
                    if (state1.isAmbiguous() || state2.isAmbiguous()) continue;
                    noGapsPairFound = true;
                    double weight = pattern.getWeight();
                    if (state1 != state2) {
                        if (Nucleotides.isTransition(state1, state2)) {
                            sumTs += weight;
                        } else {
                            sumTv += weight;
                        }
                    }
                    sumWeight += weight;
                }
                if (!noGapsPairFound) {
                    throw new CannotBuildDistanceMatrixException("HKY", this.getTaxonName(taxon1), this.getTaxonName(taxon2));
                }
                if (sumWeight <= 0.0) {
                    return 1000.0;
                }
                while ((a = 1.0 - (P = sumTs / sumWeight) / (2.0 * this.constA) - (this.constA - this.constB) * (Q = sumTv / sumWeight) / (2.0 * this.constA * this.constC)) <= 0.0) {
                    int adjustment = (int)(1.0 + sumWeight * -a / (1.0 / (2.0 * this.constA) - 1.0));
                    if (!((sumTs -= (double)adjustment) < 0.0)) {
                        sumWeight -= (double)adjustment;
                        continue;
                    }
                    break block9;
                }
                double b = 1.0 - Q / (2.0 * this.constC);
                if (!(b < 0.0)) {
                    double distance = -(2.0 * this.constA * Math.log(a)) + 2.0 * (this.constA - this.constB - this.constC) * Math.log(b);
                    return Math.min(distance, 1000.0);
                }
            }
            return 1000.0;
        }

        private String getTaxonName(int index) {
            return this.alignment.getSequenceList().get(index).getTaxon().getName();
        }

        double[][] getDistances(Alignment alignment, ProgressListener progress, boolean useTwiceMaximumDistanceWhenPairwiseDistanceNotCalculatable) throws CannotBuildDistanceMatrixException {
            this.alignment = alignment;
            int stateCount = alignment.getSequenceType().getCanonicalStateCount();
            if (stateCount != 4) {
                throw new IllegalArgumentException("HKYDistanceMatrix must have nucleotide patterns");
            }
            double[] freqs = this.getFrequenciesSafe(alignment);
            double freqA = freqs[Nucleotides.A_STATE.getIndex()];
            double freqC = freqs[Nucleotides.C_STATE.getIndex()];
            double freqG = freqs[Nucleotides.G_STATE.getIndex()];
            double freqT = freqs[Nucleotides.T_STATE.getIndex()];
            this.constA = freqA * freqG / this.freqR + freqC * freqT / this.freqY;
            this.constB = freqA * freqG + freqC * freqT;
            this.constC = this.freqR * this.freqY;
            int dimension = alignment.getTaxa().size();
            return BasicDistanceMatrix.buildDistancesMatrix(this, dimension, useTwiceMaximumDistanceWhenPairwiseDistanceNotCalculatable, progress);
        }
    }
}

