/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

import umontreal.iro.lecuyer.hups.ContainerPointSet;
import umontreal.iro.lecuyer.hups.PointSet;
import umontreal.iro.lecuyer.hups.PointSetIterator;
import umontreal.iro.lecuyer.rng.RandomStream;

public class RandShiftedPointSet
extends ContainerPointSet {
    protected double[] shift;
    protected int dimShift = 0;
    protected int capacityShift = 0;
    protected RandomStream shiftStream;

    public RandShiftedPointSet(PointSet pointSet, int n, RandomStream randomStream) {
        this.init(pointSet);
        if (n <= 0) {
            throw new IllegalArgumentException("Cannot construct RandShiftedPointSet with dimShift <= 0");
        }
        this.shiftStream = randomStream;
        this.shift = new double[n];
        this.capacityShift = this.dimShift = n;
    }

    public int getShiftDimension() {
        return this.dimShift;
    }

    public void addRandomShift(int n, int n2, RandomStream randomStream) {
        if (null == randomStream) {
            throw new IllegalArgumentException("\n   Calling addRandomShift with null stream");
        }
        if (randomStream != this.shiftStream) {
            this.shiftStream = randomStream;
        }
        this.addRandomShift(n, n2);
    }

    public void addRandomShift(RandomStream randomStream) {
        if (randomStream != this.shiftStream) {
            this.shiftStream = randomStream;
        }
        this.addRandomShift(0, this.dimShift);
    }

    public void addRandomShift(int n, int n2) {
        int n3;
        if (n < 0 || n > n2) {
            throw new IllegalArgumentException("illegal parameter d1 or d2");
        }
        if (n2 > this.capacityShift) {
            for (n3 = Math.max(4, this.capacityShift); n2 > n3; n3 *= 2) {
            }
            double[] dArray = new double[n3];
            this.capacityShift = n3;
            for (int i = 0; i < n; ++i) {
                dArray[i] = this.shift[i];
            }
            this.shift = dArray;
        }
        this.dimShift = n2;
        for (n3 = n; n3 < n2; ++n3) {
            this.shift[n3] = this.shiftStream.nextDouble();
        }
    }

    public void addRandomShift() {
        this.addRandomShift(0, this.dimShift);
    }

    public PointSetIterator iterator() {
        return new RandShiftedPointSetIterator();
    }

    private class RandShiftedPointSetIterator
    extends ContainerPointSet.ContainerPointSetIterator {
        private RandShiftedPointSetIterator() {
        }

        public double getCoordinate(int n, int n2) {
            double d;
            int n3 = this.innerIterator.getCurCoordIndex();
            if (RandShiftedPointSet.this.dimShift <= n3) {
                RandShiftedPointSet.this.addRandomShift(RandShiftedPointSet.this.dimShift, 1 + n3);
            }
            if ((d = RandShiftedPointSet.this.P.getCoordinate(n, n2) + RandShiftedPointSet.this.shift[n2]) >= 1.0) {
                return d - 1.0;
            }
            return d;
        }

        public double nextCoordinate() {
            int n = this.innerIterator.getCurCoordIndex();
            if (RandShiftedPointSet.this.dimShift <= n) {
                RandShiftedPointSet.this.addRandomShift(RandShiftedPointSet.this.dimShift, 1 + n);
            }
            double d = RandShiftedPointSet.this.shift[n];
            if ((d += this.innerIterator.nextCoordinate()) >= 1.0) {
                return d - 1.0;
            }
            return d;
        }
    }
}

