/*
 * Decompiled with CFR 0.152.
 */
package javalain.math.fonction.simpleobjectif;

import java.util.Comparator;
import javalain.ea.SolutionEA;
import javalain.ea.operator.comparator.ObjectiveComparator;
import javalain.math.fonction.Fct;

public final class Griewank
extends Fct {
    public Griewank() {
        this(10);
    }

    public Griewank(int d) {
        this.nomFct = "Griewank";
        this.nbVariable = d;
        this.nbFctObjectif = 1;
        this.lowerLimit = new double[this.nbVariable];
        this.upperLimit = new double[this.nbVariable];
        for (int i = 0; i < this.nbVariable; ++i) {
            this.lowerLimit[i] = -600.0;
            this.upperLimit[i] = 600.0;
        }
    }

    @Override
    public double[] compute(double[] x) {
        ++this.nbEvaluation;
        double[] fct = new double[this.nbFctObjectif];
        double somme = 0.0;
        double produit = 1.0;
        for (int i = 0; i < this.nbVariable; ++i) {
            somme += x[i] * x[i];
            produit *= Math.cos(x[i] / Math.sqrt(i + 1));
        }
        fct[0] = 1.0 + somme / 4000.0 - produit;
        return fct;
    }

    @Override
    public double[][] getFront() {
        if (this.front == null) {
            this.front = new double[1][this.nbVariable];
            for (int i = 0; i < this.nbVariable; ++i) {
                this.front[0][i] = 0.0;
            }
        }
        return this.front;
    }

    @Override
    public Comparator<SolutionEA> comparator() {
        return new ObjectiveComparator(0);
    }
}

