/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.algorithm.classic;

import net.sourceforge.jclec.IConfigure;
import net.sourceforge.jclec.IIndividual;
import net.sourceforge.jclec.IMutator;
import net.sourceforge.jclec.IRecombinator;
import net.sourceforge.jclec.ISelector;
import net.sourceforge.jclec.algorithm.PopulationAlgorithm;
import net.sourceforge.jclec.base.FilteredMutator;
import net.sourceforge.jclec.base.FilteredRecombinator;
import net.sourceforge.jclec.selector.BettersSelector;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.lang.builder.EqualsBuilder;

public class SS
extends PopulationAlgorithm {
    private static final long serialVersionUID = -8711970425735016406L;
    protected int numberOfParents;
    protected ISelector parentsSelector;
    protected IRecombinator recombinator;
    protected IMutator mutator;
    protected BettersSelector bettersSelector = new BettersSelector(this);

    public final int getNumberOfParents() {
        return this.numberOfParents;
    }

    public final void setNumberOfParents(int numberOfParents) {
        this.numberOfParents = numberOfParents;
    }

    public final ISelector getParentsSelector() {
        return this.parentsSelector;
    }

    public final void setParentsSelector(ISelector parentsSelector) {
        this.parentsSelector = parentsSelector;
        parentsSelector.contextualize(this);
    }

    public final IRecombinator getRecombinator() {
        return this.recombinator;
    }

    public final void setRecombinator(IRecombinator recombinator) {
        if (recombinator instanceof FilteredRecombinator) {
            throw new IllegalArgumentException("FilteredRecombinator is invalid in Steady state algorithms");
        }
        this.recombinator = recombinator;
        recombinator.contextualize(this);
    }

    public final IMutator getMutator() {
        return this.mutator;
    }

    public final void setMutator(IMutator mutator) {
        this.mutator = mutator;
        mutator.contextualize(this);
    }

    @Override
    public void configure(Configuration settings) {
        super.configure(settings);
        int numberOfParents = settings.getInt("number-of-parents", 2);
        this.setNumberOfParents(numberOfParents);
        try {
            String parentsSelectorClassname = settings.getString("parents-selector[@type]");
            Class<?> parentsSelectorClass = Class.forName(parentsSelectorClassname);
            ISelector parentsSelector = (ISelector)parentsSelectorClass.newInstance();
            if (parentsSelector instanceof IConfigure) {
                Configuration parentsSelectorConfiguration = settings.subset("parents-selector");
                ((IConfigure)((Object)parentsSelector)).configure(parentsSelectorConfiguration);
            }
            this.setParentsSelector(parentsSelector);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal parents selector classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of parents selector", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of parents selector", e);
        }
        try {
            String recombinatorClassname = settings.getString("recombinator[@type]");
            Class<?> recombinatorClass = Class.forName(recombinatorClassname);
            IRecombinator recombinator = (IRecombinator)recombinatorClass.newInstance();
            if (recombinator instanceof IConfigure) {
                Configuration recombinatorSettings = settings.subset("recombinator");
                ((IConfigure)((Object)recombinator)).configure(recombinatorSettings);
            }
            this.setRecombinator(recombinator);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal recombinator classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of recombinator", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of recombinator", e);
        }
        try {
            String mutatorClassname = settings.getString("mutator[@type]");
            Class<?> mutatorClass = Class.forName(mutatorClassname);
            IMutator mutator = (IMutator)mutatorClass.newInstance();
            if (mutator instanceof IConfigure) {
                Configuration mutatorSettings = settings.subset("mutator");
                ((IConfigure)((Object)mutator)).configure(mutatorSettings);
            }
            this.setMutator(mutator);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal mutator classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of mutator", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of mutator", e);
        }
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof SS) {
            SS cother = (SS)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.appendSuper(super.equals(other));
            eb.append(this.numberOfParents, cother.numberOfParents);
            eb.append(this.parentsSelector, cother.parentsSelector);
            eb.append(this.mutator, cother.mutator);
            eb.append(this.recombinator, cother.recombinator);
            return eb.isEquals();
        }
        return false;
    }

    @Override
    protected void doSelection() {
        this.pset = this.parentsSelector.select(this.bset, this.numberOfParents);
    }

    @Override
    protected void doGeneration() {
        this.cset = this.recombinator.recombine(this.pset);
        this.cset = this.mutator.mutate(this.cset);
        if (this.mutator instanceof FilteredMutator) {
            FilteredMutator fmutator = (FilteredMutator)this.mutator;
            for (IIndividual sterile : fmutator.getSterile()) {
                this.cset.add(sterile.copy());
            }
        }
        this.evaluator.evaluate(this.cset);
    }

    @Override
    protected void doReplacement() {
        for (IIndividual ind : this.pset) {
            this.bset.remove(ind);
        }
    }

    @Override
    protected void doUpdate() {
        for (IIndividual ind : this.pset) {
            this.cset.add(ind);
        }
        this.cset = this.bettersSelector.select(this.cset, this.numberOfParents);
        this.bset.addAll(this.cset);
        this.pset = null;
        this.cset = null;
    }
}

