/*
 * Decompiled with CFR 0.152.
 */
package javolution.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import javolution.io.Utf8ByteBufferWriter;
import javolution.io.Utf8StreamWriter;
import javolution.lang.Reusable;
import javolution.lang.Text;
import javolution.util.FastTable;
import javolution.xml.XmlElement;
import javolution.xml.sax.ContentHandler;
import javolution.xml.sax.WriterHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectWriter<T>
implements Reusable {
    static final Text JAVOLUTION_PREFIX = Text.intern("j");
    static final Text JAVOLUTION_URI = Text.intern("http://javolution.org");
    private final Utf8StreamWriter _utf8StreamWriter = new Utf8StreamWriter();
    private final Utf8ByteBufferWriter _utf8ByteBufferWriter = new Utf8ByteBufferWriter();
    private final WriterHandler _writerHandler = new WriterHandler();
    private FastTable _namespaces = new FastTable();
    private final XmlElement _xml = new XmlElement(null);
    private String _rootName;
    private boolean _areReferencesEnabled = false;
    private boolean _expandReferences = false;
    private boolean _isClassIdentifierEnabled = true;

    public void setNamespace(String string, String string2) {
        if (string.length() == 1 && string.charAt(0) == 'j') {
            throw new IllegalArgumentException("Prefix: \"j\" is reserved.");
        }
        this._namespaces.addLast(this.toCharSeq(string));
        this._namespaces.addLast(this.toCharSeq(string2));
        if (string.length() == 0) {
            this._xml._packagePrefixes.addLast("j");
            this._xml._packagePrefixes.addLast("");
        }
    }

    public void setPackagePrefix(String string, String string2) {
        this.setNamespace(string, "java:" + string2);
        this._xml._packagePrefixes.addLast(string);
        this._xml._packagePrefixes.addLast(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(T t, Writer writer) throws IOException {
        try {
            this._writerHandler.setWriter(writer);
            this.write(t, this._writerHandler);
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() instanceof IOException) {
                throw (IOException)sAXException.getException();
            }
        }
        finally {
            this._writerHandler.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(T t, OutputStream outputStream) throws IOException {
        try {
            this._utf8StreamWriter.setOutputStream(outputStream);
            this._writerHandler.setWriter(this._utf8StreamWriter);
            this.write(t, this._writerHandler);
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() instanceof IOException) {
                throw (IOException)sAXException.getException();
            }
        }
        finally {
            this._utf8StreamWriter.reset();
            this._writerHandler.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(T t, ByteBuffer byteBuffer) throws IOException {
        try {
            this._utf8ByteBufferWriter.setByteBuffer(byteBuffer);
            this._writerHandler.setWriter(this._utf8ByteBufferWriter);
            this.write(t, this._writerHandler);
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() instanceof IOException) {
                throw (IOException)sAXException.getException();
            }
        }
        finally {
            this._utf8ByteBufferWriter.reset();
            this._writerHandler.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(T t, ContentHandler contentHandler) throws SAXException {
        CharSequence charSequence;
        int n;
        contentHandler.startDocument();
        try {
            contentHandler.startPrefixMapping(JAVOLUTION_PREFIX, JAVOLUTION_URI);
            n = 0;
            while (n < this._namespaces.size()) {
                charSequence = (CharSequence)this._namespaces.get(n++);
                CharSequence charSequence2 = (CharSequence)this._namespaces.get(n++);
                contentHandler.startPrefixMapping(charSequence, charSequence2);
            }
            this._xml._formatHandler = contentHandler;
            this._xml._areReferencesEnabled = this._areReferencesEnabled;
            this._xml._expandReferences = this._expandReferences;
            this._xml._isClassIdentifierEnabled = this._isClassIdentifierEnabled;
            if (this._rootName != null) {
                this._xml.add(t, this._rootName);
            } else {
                this._xml.add(t);
            }
        }
        finally {
            contentHandler.endPrefixMapping(JAVOLUTION_PREFIX);
            for (n = 0; n < this._namespaces.size(); ++n) {
                charSequence = (CharSequence)this._namespaces.get(n++);
                contentHandler.endPrefixMapping(charSequence);
            }
            contentHandler.endDocument();
            this._xml.reset();
        }
    }

    @Override
    public void reset() {
        this._xml.reset();
        this._namespaces.clear();
        this._xml._packagePrefixes.clear();
        this._areReferencesEnabled = false;
        this._expandReferences = false;
        this._isClassIdentifierEnabled = true;
    }

    private CharSequence toCharSeq(Object object) {
        if (object instanceof CharSequence) {
            return (CharSequence)object;
        }
        return Text.valueOf((String)object);
    }

    public void setReferencesEnabled(boolean bl) {
        this._areReferencesEnabled = bl;
    }

    public void setExpandReferences(boolean bl) {
        this._expandReferences = bl;
    }

    public void setClassIdentifierEnabled(boolean bl) {
        this._isClassIdentifierEnabled = bl;
    }

    public void setRootName(String string) {
        this._rootName = string;
    }
}

