/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Genetic_Rule_Learning.Bojarczuk_GP;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import net.sourceforge.jclec.RunExperiment;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;

public class Main {
    public static void main(String[] args) {
        Main.configureJob(args[0]);
    }

    private static void configureJob(String jobFilename) {
        Properties props = new Properties();
        try {
            FileInputStream paramsFile = new FileInputStream(jobFilename);
            props.load(paramsFile);
            ((InputStream)paramsFile).close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(0);
        }
        StringTokenizer tokenizer = new StringTokenizer(props.getProperty("inputData"));
        tokenizer.nextToken();
        String trainFile = tokenizer.nextToken();
        trainFile = trainFile.substring(1, trainFile.length() - 1);
        String testFile = tokenizer.nextToken();
        testFile = testFile.substring(1, testFile.length() - 1);
        tokenizer = new StringTokenizer(props.getProperty("outputData"));
        String reportTrainFile = tokenizer.nextToken();
        reportTrainFile = reportTrainFile.substring(1, reportTrainFile.length() - 1);
        String reportTestFile = tokenizer.nextToken();
        reportTestFile = reportTestFile.substring(1, reportTestFile.length() - 1);
        String reportRulesFile = tokenizer.nextToken();
        reportRulesFile = reportRulesFile.substring(1, reportRulesFile.length() - 1);
        XMLConfiguration algConf = new XMLConfiguration();
        algConf.setRootElementName("experiment");
        algConf.addProperty("process[@algorithm-type]", "net.sourceforge.jclec.problem.classification.freitas.FreitasAlgorithm");
        algConf.addProperty("process.rand-gen-factory[@type]", "net.sourceforge.jclec.util.random.RanecuFactory");
        algConf.addProperty("process.rand-gen-factory[@seed]", Integer.parseInt(props.getProperty("seed")));
        algConf.addProperty("process.population-size", Integer.parseInt(props.getProperty("population-size")));
        algConf.addProperty("process.max-of-generations", Integer.parseInt(props.getProperty("max-generations")));
        algConf.addProperty("process.max-deriv-size", Integer.parseInt(props.getProperty("max-deriv-size")));
        algConf.addProperty("process.dataset[@type]", "net.sourceforge.jclec.util.dataset.KeelDataSet");
        algConf.addProperty("process.dataset.train-data.file-name", trainFile);
        algConf.addProperty("process.dataset.test-data.file-name", testFile);
        algConf.addProperty("process.species[@type]", "net.sourceforge.jclec.problem.classification.freitas.FreitasSyntaxTreeSpecies");
        algConf.addProperty("process.evaluator[@type]", "net.sourceforge.jclec.problem.classification.freitas.FreitasEvaluator");
        algConf.addProperty("process.provider[@type]", "net.sourceforge.jclec.syntaxtree.SyntaxTreeCreator");
        algConf.addProperty("process.parents-selector[@type]", "net.sourceforge.jclec.selector.RouletteSelector");
        algConf.addProperty("process.recombinator[@type]", "net.sourceforge.jclec.syntaxtree.SyntaxTreeRecombinator");
        algConf.addProperty("process.recombinator[@rec-prob]", Double.parseDouble(props.getProperty("rec-prob")));
        algConf.addProperty("process.recombinator.base-op[@type]", "net.sourceforge.jclec.problem.classification.freitas.FreitasCrossover");
        algConf.addProperty("process.copy-prob", Double.parseDouble(props.getProperty("copy-prob")));
        algConf.addProperty("process.listener[@type]", "net.sourceforge.jclec.problem.classification.freitas.KeelFreitasPopulationReport");
        algConf.addProperty("process.listener.report-dir-name", "./");
        algConf.addProperty("process.listener.train-report-file", reportTrainFile);
        algConf.addProperty("process.listener.test-report-file", reportTestFile);
        algConf.addProperty("process.listener.rules-report-file", reportRulesFile);
        algConf.addProperty("process.listener.global-report-name", "resumen");
        algConf.addProperty("process.listener.report-frequency", 50);
        try {
            algConf.save(new File("configure.txt"));
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        RunExperiment.main(new String[]{"configure.txt"});
    }
}

