/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.intarray;

import net.sourceforge.jclec.ISpecies;
import net.sourceforge.jclec.base.AbstractMutator;
import net.sourceforge.jclec.intarray.IntArraySpecies;
import net.sourceforge.jclec.util.intset.IIntegerSet;

public abstract class IntArrayMutator
extends AbstractMutator {
    protected transient IntArraySpecies species;
    protected transient IIntegerSet[] schema;

    @Override
    protected void prepareMutation() {
        ISpecies spc = this.context.getSpecies();
        if (!(spc instanceof IntArraySpecies)) {
            throw new IllegalStateException("Invalid species in context");
        }
        this.species = (IntArraySpecies)spc;
        this.schema = this.species.getGenotypeSchema();
    }

    protected final int getMutableLocus() {
        int ml;
        int genotypeLength = this.schema.length;
        while (this.schema[ml = this.randgen.choose(0, genotypeLength)].size() == 1) {
        }
        return ml;
    }

    protected final void flip(int[] chrom, int locus) {
        int newval;
        while (chrom[locus] == (newval = this.schema[locus].getRandom(this.randgen))) {
        }
        chrom[locus] = newval;
    }
}

