/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.problem.classification.stefano;

import net.sourceforge.jclec.IConfigure;
import net.sourceforge.jclec.IIndividual;
import net.sourceforge.jclec.IMutator;
import net.sourceforge.jclec.ISelector;
import net.sourceforge.jclec.algorithm.PopulationAlgorithm;
import net.sourceforge.jclec.base.FilteredMutator;
import net.sourceforge.jclec.problem.classification.IClassificationRule;
import net.sourceforge.jclec.problem.classification.Individual;
import net.sourceforge.jclec.problem.classification.SyntaxTreeClassificationRule;
import net.sourceforge.jclec.problem.classification.stefano.StefanoClassifier;
import net.sourceforge.jclec.problem.classification.stefano.StefanoEvaluator;
import net.sourceforge.jclec.problem.classification.stefano.StefanoSyntaxTreeSpecies;
import net.sourceforge.jclec.selector.BettersSelector;
import net.sourceforge.jclec.selector.WorsesSelector;
import net.sourceforge.jclec.util.dataset.CategoricalAttribute;
import net.sourceforge.jclec.util.dataset.DatasetException;
import net.sourceforge.jclec.util.dataset.IDataset;
import net.sourceforge.jclec.util.dataset.IMetadata;
import net.sourceforge.jclec.util.random.AbstractRandGenFactory;
import net.sourceforge.jclec.util.random.IRandGen;
import net.sourceforge.jclec.util.random.RanecuFactory;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.lang.builder.EqualsBuilder;

public class StefanoAlgorithm
extends PopulationAlgorithm {
    private static final long serialVersionUID = -8711970425735016406L;
    protected ISelector parentsSelector;
    protected FilteredMutator mutator;
    protected StefanoClassifier classifier;
    double copyProb;
    private IDataset trainSet;
    private IDataset testSet;
    private IMetadata trainMetadata;
    private IMetadata testMetadata;
    protected int classesNumber;
    protected int execution = 0;
    protected IRandGen randgen;
    protected BettersSelector bettersSelector = new BettersSelector(this);
    WorsesSelector worsesSelector = new WorsesSelector(this);
    private double pi = 0.0;

    public ISelector getParentsSelector() {
        return this.parentsSelector;
    }

    public void setParentsSelector(ISelector parentsSelector) {
        this.parentsSelector = parentsSelector;
        parentsSelector.contextualize(this);
    }

    public FilteredMutator getMutator() {
        return this.mutator;
    }

    public void setMutator(IMutator mutator) {
        if (this.mutator == null) {
            this.mutator = new FilteredMutator(this);
        }
        this.mutator.setDecorated(mutator);
    }

    public StefanoClassifier getClassifier() {
        return this.classifier;
    }

    public void setClassifier(StefanoClassifier classifier) {
        this.classifier = classifier;
    }

    public double getCopyProb() {
        return this.copyProb;
    }

    public void setCopyProb(double copyProb) {
        this.copyProb = copyProb;
    }

    public IDataset getTrainSet() {
        return this.trainSet;
    }

    public void setTrainSet(IDataset train) {
        this.trainSet = train;
    }

    public IDataset getTestSet() {
        return this.testSet;
    }

    public void setTestSet(IDataset test) {
        this.testSet = test;
    }

    public IMetadata getTrainMetadata() {
        return this.trainMetadata;
    }

    public void setTrainMetadata(IMetadata train) {
        this.trainMetadata = train;
    }

    public IMetadata getTestMetadata() {
        return this.testMetadata;
    }

    public void setTestMetadata(IMetadata test) {
        this.testMetadata = test;
    }

    @Override
    public void configure(Configuration settings) {
        super.configure(settings);
        this.setDatasetSettings(settings);
        int maxDerivSize = settings.getInt("max-deriv-size");
        ((StefanoSyntaxTreeSpecies)this.getSpecies()).setStefanoGrammar();
        ((StefanoSyntaxTreeSpecies)this.getSpecies()).setMaxDerivSize(maxDerivSize);
        RanecuFactory randGenFactory = new RanecuFactory();
        int seed = ((AbstractRandGenFactory)this.getRandGenFactory()).getSeed();
        randGenFactory.setSeed(seed);
        ((StefanoEvaluator)this.evaluator).setRandGen(randGenFactory.createRandGen());
        ((StefanoEvaluator)this.evaluator).setMaxDerivSize(maxDerivSize);
        this.setParentsSelectorSettings(settings);
        this.setMutatorSettings(settings);
        double copyProb = settings.getDouble("copy-prob", 0.1);
        this.setCopyProb(copyProb);
        double pi = settings.getDouble("pi-parameter", 0.4);
        this.setPiPercentage(pi);
    }

    public void setPiPercentage(double pi) {
        this.pi = pi;
    }

    public double getPiPercentage() {
        return this.pi;
    }

    private void setMutatorSettings(Configuration settings) {
        try {
            String mutatorClassname = settings.getString("mutator[@type]");
            Class<?> mutatorClass = Class.forName(mutatorClassname);
            IMutator mutator = (IMutator)mutatorClass.newInstance();
            if (mutator instanceof IConfigure) {
                Configuration mutatorConfiguration = settings.subset("mutator");
                ((IConfigure)((Object)mutator)).configure(mutatorConfiguration);
            }
            this.setMutator(mutator);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal mutator classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of mutator", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of mutator", e);
        }
        double mutProb = settings.getDouble("mutator[@mut-prob]", 0.05);
        this.setMutationProb(mutProb);
    }

    private void setParentsSelectorSettings(Configuration settings) {
        try {
            String parentsSelectorClassname = settings.getString("parents-selector[@type]");
            Class<?> parentsSelectorClass = Class.forName(parentsSelectorClassname);
            ISelector parentsSelector = (ISelector)parentsSelectorClass.newInstance();
            if (parentsSelector instanceof IConfigure) {
                Configuration parentsSelectorConfiguration = settings.subset("parents-selector");
                ((IConfigure)((Object)parentsSelector)).configure(parentsSelectorConfiguration);
            }
            this.setParentsSelector(parentsSelector);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal parents selector classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of parents selector", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of parents selector", e);
        }
    }

    private void setDatasetSettings(Configuration settings) {
        try {
            String datasetClassname = settings.getString("dataset[@type]");
            Class<?> datasetClass = Class.forName(datasetClassname);
            this.setTrainSet((IDataset)datasetClass.newInstance());
            Configuration datasetSettings = settings.subset("dataset.train-data");
            this.getTrainSet().configure(datasetSettings);
            this.setTestSet((IDataset)datasetClass.newInstance());
            datasetSettings = settings.subset("dataset.test-data");
            this.getTestSet().configure(datasetSettings);
            this.getTrainSet().open();
            this.setTrainMetadata(this.getTrainSet().getMetadata());
            this.getTrainSet().loadInstances();
            this.getTrainSet().close();
            this.getTestSet().open();
            this.setTestMetadata(this.getTestSet().getMetadata());
            this.getTestSet().loadInstances();
            this.getTestSet().close();
            String attributeClass = settings.getString("dataset.attribute-class-name");
            if (attributeClass != null) {
                int attributeClassIndex = this.getTrainMetadata().getIndex(attributeClass);
                this.getTrainMetadata().setClassIndex(attributeClassIndex);
                this.getTestMetadata().setClassIndex(attributeClassIndex);
            } else {
                this.getTrainMetadata().setClassIndex(this.trainMetadata.numberOfAttributes() - 1);
                this.getTestMetadata().setClassIndex(this.testMetadata.numberOfAttributes() - 1);
            }
            this.classifier.setDefaultClass(0.0);
            ((StefanoSyntaxTreeSpecies)this.getSpecies()).setMetadata(this.getTrainMetadata());
            CategoricalAttribute catAttr = (CategoricalAttribute)this.getTrainMetadata().getAttribute(this.getTrainMetadata().getClassIndex());
            this.setClassesNumber(catAttr.getCategories().size());
            ((StefanoEvaluator)this.evaluator).setDataset(this.getTrainSet());
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (InstantiationException e1) {
            e1.printStackTrace();
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
        }
        catch (DatasetException e) {
            e.printStackTrace();
        }
    }

    private void setClassesNumber(int size) {
        this.classesNumber = size;
    }

    private void setMutationProb(double mutProb) {
        this.mutator.setMutProb(mutProb);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof StefanoAlgorithm) {
            StefanoAlgorithm cother = (StefanoAlgorithm)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.appendSuper(super.equals(other));
            eb.append(this.parentsSelector, cother.parentsSelector);
            eb.append(this.mutator, cother.mutator);
            return eb.isEquals();
        }
        return false;
    }

    @Override
    protected void doSelection() {
        this.pset = this.parentsSelector.select(this.bset);
    }

    @Override
    protected void doGeneration() {
        this.cset = this.mutator.mutate(this.pset);
        for (IIndividual ind : this.mutator.getSterile()) {
            this.cset.add(ind);
        }
        this.evaluator.evaluate(this.cset);
    }

    @Override
    protected void doReplacement() {
        this.rset = this.bset;
    }

    @Override
    protected void doUpdate() {
        IIndividual bestb = this.bettersSelector.select(this.bset, 1).get(0);
        IIndividual bestc = this.bettersSelector.select(this.cset, 1).get(0);
        if (this.evaluator.getComparator().compare(bestb.getFitness(), bestc.getFitness()) == 1) {
            IIndividual worstc = this.worsesSelector.select(this.cset, 1).get(0);
            this.cset.remove(worstc);
            this.cset.add(bestb);
        }
        this.bset = this.cset;
        this.pset = null;
        this.rset = null;
        this.cset = null;
    }

    @Override
    protected void doControl() {
        boolean bool = false;
        if (this.generation >= this.maxOfGenerations) {
            double[] consecuentes = new double[((CategoricalAttribute)this.getTrainMetadata().getAttribute(this.getTrainMetadata().getClassIndex())).intervalValues().size() + 1];
            IDataset.IInstance[] instances = this.getTrainSet().getInstances();
            int numInstances = instances.length;
            for (IIndividual ind : this.bset) {
                IClassificationRule phenotype = ((Individual)ind).getPhenotype();
                int i = 0;
                while (i < consecuentes.length) {
                    consecuentes[i] = 0.0;
                    ++i;
                }
                i = 0;
                while (i < numInstances) {
                    IDataset.IInstance instance = instances[i];
                    SyntaxTreeClassificationRule rule = (SyntaxTreeClassificationRule)((Individual)ind).getPhenotype();
                    if (rule.covers(instance)) {
                        int n = (int)instance.getValue(this.getTrainMetadata().getClassIndex());
                        consecuentes[n] = consecuentes[n] + 1.0;
                    }
                    ++i;
                }
                i = 0;
                while (i < consecuentes.length) {
                    if (this.getPiPercentage() > consecuentes[i] / (double)numInstances) {
                        consecuentes[i] = -1.0;
                    } else {
                        consecuentes[i] = i;
                        bool = true;
                    }
                    ++i;
                }
                phenotype.setConsequents(consecuentes);
                if (this.classifier.getClassificationRules() == null) {
                    this.classifier.addClassificationRule(phenotype);
                } else if (bool && !this.classifier.getClassificationRules().contains(phenotype)) {
                    this.classifier.addClassificationRule(phenotype);
                }
                bool = false;
            }
            this.state = 3;
        }
    }
}

