## ----echo = FALSE-------------------------------------------------------------
library(YEAB)

## -----------------------------------------------------------------------------
data("gauss_example")
t_example <- gauss_example$Bin
res_example <- gauss_example$Response_Average

## -----------------------------------------------------------------------------
par_est <- gaussian_fit(responses = res_example, time = t_example, max.iter = 1000)

print(par_est, digits = 3)

## -----------------------------------------------------------------------------
g_plus_lin <- function(par, tiempo) {
  par$a * exp(-0.5 * ((tiempo - par$t0) / par$b)**2) + par$c * (tiempo - par$t0) + par$d
} # The gaussian + linear model.

time_points <- seq(0, 90, 0.1) # In this example we used a FI30 program so the trail lenght is 90s.
y_fit <- g_plus_lin(par_est |> as.list(), time_points) # This function creates the data points using the estimated parameters applied to a Gaussian + linear function.

## ----echo = FALSE-------------------------------------------------------------
plot(time_points,
  y_fit,
  type = "l",
  col = "black",
  lwd = 2,
  ylim = c(0, max(y_fit, res_example)),
  xlab = "Time in trial",
  ylab = "R(t)",
)

points(t_example, res_example, pch = 21, bg = "red", cex = .8)

legend(
  "topright",
  legend = c("nls.lm fit", "data"),
  lty = c(1, 0),
  pch = c(NA, 21),
  pt.bg = c(NA, "red"),
  col = c("black", 1),
  pt.cex = 1,
  cex = .8
)

