/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public class ImageKit {
    private static ByteArrayOutputStream sOut = new ByteArrayOutputStream(200000);

    public static Image getFileImage(String string) {
        BufferedImage bufferedImage = null;
        byte[] byArray = ImageKit.getFileBytes(string);
        if (byArray.length > 0) {
            bufferedImage = ImageKit.read(byArray);
        }
        return bufferedImage;
    }

    public static byte[] getFileBytes(String string) {
        byte[] byArray = new byte[]{};
        File file = new File(string);
        if (file.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray2 = new byte[2048];
                int n = 0;
                while ((n = fileInputStream.read(byArray2)) > -1) {
                    byteArrayOutputStream.write(byArray2, 0, n);
                }
                fileInputStream.close();
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return byArray;
    }

    public static Rectangle getModifiedRect(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (bufferedImage == null || bufferedImage2 == null) {
            return null;
        }
        if (bufferedImage.getWidth() != bufferedImage2.getWidth() || bufferedImage.getHeight() != bufferedImage2.getHeight()) {
            return null;
        }
        if (bufferedImage.getRaster().getTransferType() != bufferedImage2.getRaster().getTransferType()) {
            return null;
        }
        long l = System.currentTimeMillis();
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = bufferedImage.getWidth();
        int n6 = bufferedImage.getHeight();
        if (bufferedImage.getRaster().getDataBuffer() instanceof DataBufferInt) {
            DataBufferInt dataBufferInt = (DataBufferInt)bufferedImage.getRaster().getDataBuffer();
            DataBufferInt dataBufferInt2 = (DataBufferInt)bufferedImage2.getRaster().getDataBuffer();
            int[] nArray = dataBufferInt.getData();
            int[] nArray2 = dataBufferInt2.getData();
            for (int i = 0; i < n6; ++i) {
                for (int j = 0; j < n5; ++j) {
                    if (nArray[j + i * n5] == nArray2[j + i * n5]) continue;
                    if (j < n) {
                        n = j;
                    }
                    if (j > n4) {
                        n4 = j;
                    }
                    if (n3 == 0) {
                        n3 = i;
                    }
                    n2 = i;
                }
            }
            if (n == Integer.MAX_VALUE) {
                n = 0;
            }
        } else {
            DataBufferByte dataBufferByte = (DataBufferByte)bufferedImage.getRaster().getDataBuffer();
            DataBufferByte dataBufferByte2 = (DataBufferByte)bufferedImage2.getRaster().getDataBuffer();
            byte[] byArray = dataBufferByte.getData();
            byte[] byArray2 = dataBufferByte2.getData();
            for (int i = 0; i < n6; ++i) {
                for (int j = 0; j < n5; ++j) {
                    if (byArray[j + i * n5] == byArray2[j + i * n5]) continue;
                    if (j < n) {
                        n = j;
                    }
                    if (j > n4) {
                        n4 = j;
                    }
                    if (n3 == 0) {
                        n3 = i;
                    }
                    n2 = i;
                }
            }
            if (n == Integer.MAX_VALUE) {
                n = 0;
            }
        }
        rectangle.x = n;
        rectangle.y = n3;
        rectangle.width = n4 - n;
        rectangle.height = n2 - n3;
        long l2 = System.currentTimeMillis();
        return rectangle;
    }

    public static void write(BufferedImage bufferedImage, float f, OutputStream outputStream) throws IOException {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersBySuffix("jpeg");
        if (!iterator.hasNext()) {
            throw new IllegalStateException("No writers found");
        }
        ImageWriter imageWriter = iterator.next();
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(outputStream);
        imageWriter.setOutput(imageOutputStream);
        ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
        if (f >= 0.0f) {
            imageWriteParam.setCompressionMode(2);
            imageWriteParam.setCompressionQuality(f);
        }
        IIOImage iIOImage = new IIOImage(bufferedImage, null, null);
        imageWriter.write(null, iIOImage, imageWriteParam);
        imageWriter.dispose();
        imageWriteParam = null;
        imageWriter = null;
        iIOImage = null;
        bufferedImage = null;
        System.gc();
    }

    public static BufferedImage read(byte[] byArray) {
        try {
            return ImageIO.read(new ByteArrayInputStream(byArray));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static byte[] getBytes(BufferedImage bufferedImage, float f) {
        try {
            sOut.reset();
            ImageKit.write(bufferedImage, f, sOut);
            byte[] byArray = sOut.toByteArray();
            System.gc();
            return byArray;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static void storeImage(Image image, int n, int n2, float f, File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ImageKit.write(ImageKit.convert(image, n, n2), f, fileOutputStream);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static BufferedImage convert(Image image, int n, int n2) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(image, 0, 0, null);
        graphics.dispose();
        return bufferedImage;
    }

    public static byte[] getZippedBytes(int[] nArray) {
        sOut.reset();
        try {
            int n = 0;
            while (n < nArray.length) {
                int n2 = nArray[n];
                int n3 = n++;
                while (n < nArray.length && nArray[n] == n2) {
                    ++n;
                }
                ImageKit.writeInt(sOut, n - n3);
                ImageKit.writeInt(sOut, n2);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        byte[] byArray = sOut.toByteArray();
        return byArray;
    }

    public static byte[] getZippedBytes(BufferedImage bufferedImage) {
        DataBufferInt dataBufferInt = (DataBufferInt)bufferedImage.getRaster().getDataBuffer();
        int[] nArray = dataBufferInt.getData();
        return ImageKit.getZippedBytes(nArray);
    }

    public static byte[] getUnzippedByptes(byte[] byArray) {
        sOut.reset();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        boolean bl = false;
        while (!bl) {
            try {
                int n = ImageKit.readInt(byteArrayInputStream);
                int n2 = ImageKit.readInt(byteArrayInputStream);
                for (int i = 0; i < n; ++i) {
                    ImageKit.writeInt(sOut, n2);
                }
            }
            catch (EOFException eOFException) {
                bl = true;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        byte[] byArray2 = sOut.toByteArray();
        return byArray2;
    }

    public static BufferedImage readZippedBytes(byte[] byArray, int n, int n2) {
        byte[] byArray2 = ImageKit.getUnzippedByptes(byArray);
        DirectColorModel directColorModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
        int[] nArray = new int[3];
        int[] nArray2 = new int[byArray2.length / 4];
        for (int i = 0; i < nArray2.length; ++i) {
            int n3 = byArray2[4 * i] << 24;
            int n4 = byArray2[4 * i + 1] << 16;
            int n5 = byArray2[4 * i + 2] << 8;
            byte by = byArray2[4 * i + 3];
            nArray2[i] = (n3 & 0xFF000000) + (n4 & 0xFF0000) + (n5 & 0xFF00) + (by & 0xFF);
        }
        DataBufferInt dataBufferInt = new DataBufferInt(nArray2, nArray2.length);
        nArray[0] = directColorModel.getRedMask();
        nArray[1] = directColorModel.getGreenMask();
        nArray[2] = directColorModel.getBlueMask();
        WritableRaster writableRaster = Raster.createPackedRaster(dataBufferInt, n, n2, n, nArray, null);
        BufferedImage bufferedImage = new BufferedImage(directColorModel, writableRaster, false, null);
        return bufferedImage;
    }

    public static byte[] getBytes(BufferedImage bufferedImage, String string) {
        try {
            sOut.reset();
            IIOImage iIOImage = new IIOImage(bufferedImage, null, null);
            ImageIO.write(iIOImage.getRenderedImage(), string, sOut);
            byte[] byArray = sOut.toByteArray();
            System.gc();
            return byArray;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static BufferedImage compress(BufferedImage bufferedImage, float f) {
        try {
            ImageKit.write(bufferedImage, f, sOut);
            return ImageIO.read(new ByteArrayInputStream(sOut.toByteArray()));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static BufferedImage sub(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        block3: {
            DataBuffer dataBuffer;
            DataBuffer dataBuffer2;
            block2: {
                dataBuffer2 = bufferedImage.getRaster().getDataBuffer();
                dataBuffer = bufferedImage2.getRaster().getDataBuffer();
                if (!(dataBuffer2 instanceof DataBufferInt) || !(dataBuffer instanceof DataBufferInt)) break block2;
                int[] nArray = ((DataBufferInt)dataBuffer2).getData();
                int[] nArray2 = ((DataBufferInt)dataBuffer).getData();
                for (int i = 0; i < nArray.length; ++i) {
                    int n = i;
                    nArray2[n] = nArray2[n] ^ nArray[i];
                }
                break block3;
            }
            if (!(dataBuffer2 instanceof DataBufferByte) || !(dataBuffer instanceof DataBufferByte)) break block3;
            byte[] byArray = ((DataBufferByte)dataBuffer2).getData();
            byte[] byArray2 = ((DataBufferByte)dataBuffer).getData();
            for (int i = 0; i < byArray.length; ++i) {
                int n = i;
                byArray2[n] = (byte)(byArray2[n] ^ byArray[i]);
            }
        }
        return bufferedImage2;
    }

    public static BufferedImage add(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        block3: {
            DataBuffer dataBuffer;
            DataBuffer dataBuffer2;
            block2: {
                dataBuffer2 = bufferedImage.getRaster().getDataBuffer();
                dataBuffer = bufferedImage2.getRaster().getDataBuffer();
                if (!(dataBuffer2 instanceof DataBufferInt) || !(dataBuffer instanceof DataBufferInt)) break block2;
                int[] nArray = ((DataBufferInt)dataBuffer2).getData();
                int[] nArray2 = ((DataBufferInt)dataBuffer).getData();
                for (int i = 0; i < nArray.length; ++i) {
                    int n = i;
                    nArray[n] = nArray[n] ^ nArray2[i];
                }
                break block3;
            }
            if (!(dataBuffer2 instanceof DataBufferByte) || !(dataBuffer instanceof DataBufferByte)) break block3;
            byte[] byArray = ((DataBufferByte)dataBuffer2).getData();
            byte[] byArray2 = ((DataBufferByte)dataBuffer).getData();
            for (int i = 0; i < byArray.length; ++i) {
                int n = i;
                byArray[n] = (byte)(byArray[n] ^ byArray2[i]);
            }
        }
        return bufferedImage;
    }

    public static int readInt(InputStream inputStream) throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = inputStream.read();
        if ((n4 | (n3 = inputStream.read()) | (n2 = inputStream.read()) | (n = inputStream.read())) < 0) {
            throw new EOFException();
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + (n << 0);
    }

    public static void writeInt(OutputStream outputStream, int n) throws IOException {
        outputStream.write((byte)(n >> 24 & 0xFF));
        outputStream.write((byte)(n >> 16 & 0xFF));
        outputStream.write((byte)(n >> 8 & 0xFF));
        outputStream.write((byte)(n >> 0 & 0xFF));
    }
}

