/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.swing;

import com.qarks.util.ui.swing.AHtmlRef;
import com.qarks.util.ui.swing.HtmlLink;
import com.qarks.util.ui.swing.events.HidablePanelEvent;
import com.qarks.util.ui.swing.events.HidablePanelListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class HidablePanel
extends JPanel {
    private HtmlLink showContent;
    private boolean visible = false;
    private JPanel toolbar;
    private String showLabel;
    private String hideLabel;
    private Vector<HidablePanelListener> listeners = new Vector();

    public HidablePanel(JComponent jComponent, boolean bl, String string, String string2) {
        this.showLabel = string;
        this.hideLabel = string2;
        this.setLayout(new BorderLayout());
        this.toolbar = new JPanel(new FlowLayout(0, 0, 0));
        if (bl) {
            this.visible = true;
            this.showContent = new HtmlLink(string2);
        } else {
            this.visible = false;
            this.showContent = new HtmlLink(string);
        }
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.add((Component)this.toolbar, "West");
        jPanel.add((Component)this.showContent, "East");
        this.add((Component)jPanel, "North");
        this.add((Component)jComponent, "Center");
        this.showContent.setRef(new ShowContentRef());
    }

    public void addComponentInToolbar(JComponent jComponent) {
        this.toolbar.add(jComponent);
    }

    public void removeComponentFromToolbar(JComponent jComponent) {
        this.toolbar.remove(jComponent);
    }

    public void addHidablePanelListener(HidablePanelListener hidablePanelListener) {
        this.listeners.add(hidablePanelListener);
    }

    public void removeHidablePanelListener(HidablePanelListener hidablePanelListener) {
        this.listeners.remove(hidablePanelListener);
    }

    private void fireHidablePanelEvent(HidablePanelEvent hidablePanelEvent) {
        Vector vector = (Vector)this.listeners.clone();
        for (int i = 0; i < vector.size(); ++i) {
            HidablePanelListener hidablePanelListener = (HidablePanelListener)vector.get(i);
            hidablePanelListener.onHidablePanelStateChanged(hidablePanelEvent);
        }
    }

    public boolean isContentVisible() {
        return this.visible;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = this.toolbar.getPreferredSize();
        if (this.visible) {
            dimension = super.getPreferredSize();
        }
        return dimension;
    }

    public void setHidden(boolean bl) {
        boolean bl2 = false;
        if (bl && this.visible) {
            this.showContent.setLabel(this.showLabel);
            this.visible = false;
            this.fireHidablePanelEvent(new HidablePanelEvent(this, false));
            bl2 = true;
        } else if (!bl && !this.visible) {
            this.showContent.setLabel(this.hideLabel);
            this.visible = true;
            this.fireHidablePanelEvent(new HidablePanelEvent(this, true));
            bl2 = true;
        }
        if (bl2) {
            this.invalidate();
            SwingUtilities.getWindowAncestor(this).validate();
        }
    }

    private class ShowContentRef
    extends AHtmlRef {
        @Override
        public void launchRef(MouseEvent mouseEvent) {
            if (HidablePanel.this.visible) {
                HidablePanel.this.setHidden(true);
            } else {
                HidablePanel.this.setHidden(false);
            }
        }
    }
}

