/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.impl;

import org.chocosolver.solver.Model;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.impl.FixedIntVarImpl;
import org.chocosolver.solver.variables.impl.scheduler.BoolEvtScheduler;
import org.chocosolver.util.ESat;
import org.chocosolver.util.iterators.EvtScheduler;

public class FixedBoolVarImpl
extends FixedIntVarImpl
implements BoolVar {
    private BoolVar not;

    public FixedBoolVarImpl(String name, int constant, Model model) {
        super(name, constant, model);
        assert (constant == 0 || constant == 1) : "FixedBoolVarImpl value should be taken in {0,1}";
    }

    @Override
    public int getTypeAndKind() {
        return 26;
    }

    protected EvtScheduler createScheduler() {
        return new BoolEvtScheduler();
    }

    @Override
    public ESat getBooleanValue() {
        return ESat.eval(this.constante == 1);
    }

    @Override
    public BoolVar not() {
        if (!this.hasNot()) {
            this.not = this.model.boolNotView(this);
            this.not._setNot(this);
        }
        return this.not;
    }

    @Override
    public void _setNot(BoolVar not) {
        this.not = not;
    }

    @Override
    public boolean isLit() {
        return true;
    }

    @Override
    public boolean hasNot() {
        return this.not != null;
    }

    @Override
    public boolean isNot() {
        return this.constante == 0;
    }

    @Override
    public void setNot(boolean isNot) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return this.name + " = " + this.constante;
    }
}

