/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices;

import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.lapack.ScaledSumOfSquares;
import lombok.Generated;

public final class MatrixNorms {
    public static double absNorm(FastMatrix A) {
        double[] storage = A.getStorage();
        double max = 0.0;
        int i0 = A.getStartPosition();
        int cinc = A.getColumnIncrement();
        int nr = A.getRowsCount();
        int i1 = i0 + cinc * A.getColumnsCount();
        int j = i0 + nr;
        int i = i0;
        while (i < i1) {
            for (int k = i; k < j; ++k) {
                double z = storage[k];
                if (Double.isNaN(z)) {
                    return Double.NaN;
                }
                double az = Math.abs(z);
                if (!(az > max)) continue;
                max = az;
            }
            i += cinc;
            j += cinc;
        }
        return max;
    }

    public static double norm1(FastMatrix A) {
        double[] storage = A.getStorage();
        double max = 0.0;
        int i0 = A.getStartPosition();
        int nc = A.getColumnsCount();
        int cinc = A.getColumnIncrement();
        int nr = A.getRowsCount();
        int i1 = i0 + cinc * nc;
        int j = i0 + nr;
        int i = i0;
        while (i < i1) {
            double sum = 0.0;
            for (int k = i; k < j; ++k) {
                double z = storage[k];
                if (Double.isNaN(z)) {
                    return Double.NaN;
                }
                sum += Math.abs(z);
            }
            if (sum > max) {
                max = sum;
            }
            i += cinc;
            j += cinc;
        }
        return max;
    }

    public static double infinityNorm(FastMatrix A) {
        double[] storage = A.getStorage();
        double max = 0.0;
        int i0 = A.getStartPosition();
        int nc = A.getColumnsCount();
        int cinc = A.getColumnIncrement();
        int nr = A.getRowsCount();
        int i1 = i0 + nr;
        int j = i0 + cinc * nc;
        int i = i0;
        while (i < i1) {
            double sum = 0.0;
            for (int k = i; k < j; k += cinc) {
                double z = storage[k];
                if (Double.isNaN(z)) {
                    return Double.NaN;
                }
                sum += Math.abs(z);
            }
            if (sum > max) {
                max = sum;
            }
            ++i;
            ++j;
        }
        return max;
    }

    public static double frobeniusNorm(FastMatrix A) {
        double[] storage = A.getStorage();
        ScaledSumOfSquares sssq = new ScaledSumOfSquares();
        int i0 = A.getStartPosition();
        int cinc = A.getColumnIncrement();
        int nr = A.getRowsCount();
        int i1 = i0 + cinc * A.getColumnsCount();
        for (int i = i0; i < i1; i += cinc) {
            sssq.add(storage, i, nr, 1);
        }
        return sssq.sqrt();
    }

    public static double frobeniusNorm2(FastMatrix A) {
        ScaledSumOfSquares sssq = new ScaledSumOfSquares();
        int n = A.getRowsCount();
        int m = A.getColumnsCount();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                sssq.add(A.get(i, j));
            }
        }
        return sssq.sqrt();
    }

    @Generated
    private MatrixNorms() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

