/*
 * Decompiled with CFR 0.152.
 */
package dmLab.mcfs.attributesID;

import dmLab.mcfs.attributesID.AttributesID;
import dmLab.utils.StringUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;

public final class IDLoader {
    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean load(String fileName, AttributesID attrID) {
        BufferedReader file;
        attrID.init();
        try {
            file = new BufferedReader(new FileReader(fileName));
        }
        catch (IOException iOException) {
            System.err.println("Error opening file. File: " + fileName);
            return false;
        }
        String line = "";
        int lineCount = 0;
        HashMap<String, Integer> headerMap = new HashMap<String, Integer>();
        boolean useReadIDEdge = false;
        do {
            try {
                line = file.readLine();
                if (line == null) break;
                if (line.trim().length() == 0) continue;
                ++lineCount;
            }
            catch (Exception exception) {
                System.err.println("Error reading input file. Line: " + lineCount);
                try {
                    file.close();
                }
                catch (IOException e1) {
                    System.err.println("Error closing input file. File: " + fileName);
                    e1.printStackTrace();
                }
            }
            if (lineCount == 1) {
                String[] headerArray;
                String[] refHeader = AttributesID.ID_FILE_HEADER.toLowerCase().split(",");
                String[] refHeaderOld = AttributesID.ID_FILE_HEADER_OLD.toLowerCase().split(",");
                useReadIDEdge = StringUtils.allin(refHeaderOld, headerArray = line.toLowerCase().split(","), true, true);
                useReadIDEdge = useReadIDEdge || StringUtils.allin(refHeader, headerArray, true, true);
                if (useReadIDEdge) {
                    for (int i = 0; i < headerArray.length; ++i) {
                        headerMap.put(StringUtils.trimChars(headerArray[i], new char[]{'\"', '\''}).toLowerCase(), i);
                    }
                    continue;
                } else {
                    IDLoader.readIDList(line, attrID);
                    continue;
                }
            }
            if (useReadIDEdge) {
                IDLoader.readIDEdge(line, attrID, headerMap);
                continue;
            }
            IDLoader.readIDList(line, attrID);
        } while (line != null);
        try {
            void var3_3;
            var3_3.close();
            return true;
        }
        catch (IOException iOException) {
            void var1_1;
            System.err.println("Error closing file. File: " + (String)var1_1);
        }
        return true;
    }

    private static boolean readIDList(String line, AttributesID attrID) {
        String[] list = StringUtils.tokenizeString(line, new char[]{','}, false);
        int size = list.length;
        for (int i = 1; i < size; ++i) {
            String[] parsedConnection = StringUtils.tokenizeString(list[i], new char[]{'(', ')', ';'}, false);
            try {
                float weight = Float.parseFloat(parsedConnection[1]);
                attrID.addID(list[0], parsedConnection[0], weight);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Error parsing line: " + line);
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean readIDEdge(String line, AttributesID attrID, HashMap<String, Integer> headerMap) {
        Object[] refHeader = AttributesID.ID_FILE_HEADER.toLowerCase().split(",");
        Object[] refHeaderOld = AttributesID.ID_FILE_HEADER_OLD.toLowerCase().split(",");
        Object[] header = refHeader;
        if (!headerMap.containsKey(header[0].toLowerCase())) {
            header = refHeaderOld;
        }
        if (!headerMap.containsKey(header[0].toLowerCase())) {
            System.err.println("ID file does not contain correct header: " + Arrays.toString(refHeader) + " OR " + Arrays.toString(refHeaderOld));
            return false;
        }
        int parentIdx = headerMap.get(header[0]);
        int childIdx = headerMap.get(header[1]);
        int weightIdx = headerMap.get(header[2]);
        String[] values = StringUtils.tokenizeString(line, new char[]{','}, false);
        try {
            void var2_4;
            void var3_9;
            void var1_1;
            float weight = Float.parseFloat(values[weightIdx]);
            var1_1.addID(StringUtils.trimChars(values[parentIdx], new char[]{'\"', '\''}), StringUtils.trimChars((String)var3_9[childIdx], new char[]{'\"', '\''}), (float)var2_4);
        }
        catch (NumberFormatException numberFormatException) {
            String string;
            System.err.println("Error parsing line: " + string);
        }
        return true;
    }
}

