% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{ss_max}
\alias{ss_max}
\title{Compute max across columns}
\usage{
ss_max(
  data,
  name,
  vars,
  max_na = NULL,
  exclude = NULL,
  events = NULL,
  combine = TRUE
)
}
\arguments{
\item{data}{tbl. Data frame containing the columns to be summarized.}

\item{name}{character. The name of the summary score.}

\item{vars}{character vector. The names of the columns to be summarized.}

\item{max_na}{numeric, positive whole number. Number of missing items
allowed (Default: NULL; no restriction on missing values).}

\item{exclude}{character (vector). The value(s) to be excluded (Default:
NULL; all values are used).}

\item{events}{character (vector). Only compute the summary score for the
specified events (Default: NULL; computed for all events).}

\item{combine}{logical. Whether to combine the summary score column with the
input data frame (Default: TRUE).}
}
\value{
tbl. The input data frame with the summary score appended as a new
column.
}
\description{
Computes the max of a set of variables, with the option to exclude certain
values (for non-responses like "Don't know"/"Decline to answer") and to set
a maximum number of missing values.
}
\examples{

data <- tibble::tribble(
  ~id,    ~session_id, ~A, ~B,  ~C, ~D,
  "id1",  "1",         1,  5,   2,  NA,
  "id1",  "2",         2,  4,   NA, NA,
  "id1",  "3",         3,  3,   3,  3,
  "id1",  "4",         4,  2,   4,  2,
  "id1",  "5",         5,  1,   5,  3
)

ss_max(
  data,
  name = "summary",
  vars = c("A", "B", "C", "D")
)

ss_max(
  data,
  name = "summary",
  vars = c("A", "B", "C", "D"),
  max_na = 1,
  exclude = c("1")
)

ss_max(
  data,
  name = "summary",
  vars = c("A", "B", "C", "D"),
  max_na = 1,
  exclude = c("1"),
  events = c("4")
)

}
