% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MakeSigMatrix.R
\name{gListFromRF}
\alias{gListFromRF}
\title{Build a gList using random forest}
\usage{
gListFromRF(trainSet, oneCore = FALSE)
}
\arguments{
\item{trainSet}{Each row is a gene, and each column is an example of a particular cell type, e.g. ADAPTS::scSample(trainSet, groupSize=30)}

\item{oneCore}{SEt to TRUE to disable multicore (DEFAULT: FALSE)}
}
\value{
A cell specific geneList for ADAPTS::AugmentSigMatrix()
}
\description{
Use ranger to select features and build a genesInSeed gene matrix
}
\examples{
library(ADAPTS)
ct1 <- runif(1000, 0, 100)
ct2 <- runif(1000, 0, 100)
dataMat <- cbind(ct1, ct1, ct1, ct1, ct1, ct1, ct2, ct2, ct2, ct2)
rownames(dataMat) <- make.names(rep('gene', nrow(dataMat)), unique=TRUE)
noise <- matrix(runif(nrow(dataMat)*ncol(dataMat), -2, 2), nrow = nrow(dataMat), byrow = TRUE)
dataMat <- dataMat + noise
gList <- gListFromRF(trainSet=dataMat, oneCore=TRUE)

}
