% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ADMMsigma.R
\name{plot.ADMMsigma}
\alias{plot.ADMMsigma}
\title{Plot ADMMsigma object}
\usage{
\method{plot}{ADMMsigma}(x, footnote = TRUE, ...)
}
\arguments{
\item{x}{class object ADMMsigma.}

\item{footnote}{option to print footnote of optimal values. Defaults to TRUE.}

\item{...}{additional arguments.}
}
\description{
Produces a heat plot for the cross validation errors, if available.
}
\examples{
# generate data from a dense matrix
# first compute covariance matrix
S = matrix(0.9, nrow = 5, ncol = 5)
diag(S) = 1

# generate 100 x 5 matrix with rows drawn from iid N_p(0, S)
Z = matrix(rnorm(100*5), nrow = 100, ncol = 5)
out = eigen(S, symmetric = TRUE)
S.sqrt = out$vectors \%*\% diag(out$values^0.5)
S.sqrt = S.sqrt \%*\% t(out$vectors)
X = Z \%*\% S.sqrt

# produce CV heat map for ADMMsigma
plot(ADMMsigma(X))
}
