% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_rv_density.R
\name{dmvt0}
\alias{dmvt0}
\title{The density of the multivariate t distribution}
\usage{
dmvt0(x, delta, sigma, df = 1, log = TRUE)
}
\arguments{
\item{x}{vector or matrix of quantiles. If x is a matrix, each row is taken to be a quantile.}

\item{delta}{the vector of noncentrality parameters.}

\item{sigma}{numeric matrix; scale matrix.}

\item{df}{degress of freedom.}

\item{log}{logical; whether to return log density value.}
}
\description{
The density of the multivariate t distribution
}
\examples{
n <- 10
d <- 3
sigma <- crossprod(randn(d, d))
x <- rmvt0(n, sigma = sigma, df = 2)
dmvt0(x, delta = numeric(d), sigma = sigma, df = 2)

}
