% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Reintegrate.R
\name{reintegrate}
\alias{reintegrate}
\title{Reintegrate a data stream}
\usage{
reintegrate(ag, to, time_var = "Timestamp", direction = c("forwards",
  "backwards"))
}
\arguments{
\item{ag}{A data frame to reintegrate}

\item{to}{The epoch length desired. Starting epoch length will be determined
automatically.}

\item{time_var}{The name of the column containing POSIX-formatted timestamp
information}

\item{direction}{The direction of reintegration, i.e. whether a timestamp
refers to the timespan after the previous data point ("backwards"), or
before the next data point ("forwards").}
}
\description{
Reintegrate a data stream
}
\examples{

data("imu_to_check", package = "AGread")
ag <-
  imu_to_check[ ,c("Timestamp", "mean_abs_Gyroscope_x_DegPerS")]

# Forwards reintegration
  reintegrate(
    ag = ag,
    to = 60,
    time_var = "Timestamp",
    direction = c("forwards")
  )

# Backwards reintegration
  reintegrate(
    ag = ag,
    to = 60,
    time_var = "Timestamp",
    direction = c("backwards")
  )
\dontrun{
# Erronious usages that will give a warning
  reintegrate(
    ag = ag,
    to = 60,
    time_var = "Timestamp",
    direction = c("forwards", "backwards")
  )

  reintegrate(
    ag = ag,
    to = 60,
    time_var = "Timestamp"
  )
}

}
