% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AG_merge.R
\name{AG_merge}
\alias{AG_merge}
\title{Merge primary accelerometer data with IMU data}
\usage{
AG_merge(AG, primary_args = list(), IMU_args = list(),
  common_args = list(), verbose = FALSE, ...)
}
\arguments{
\item{AG}{object obtained from \code{\link{read_gt3x}}}

\item{primary_args}{additional arguments for \code{\link{collapse_gt3x.RAW}}}

\item{IMU_args}{additional arguments for \code{\link{collapse_gt3x.IMU}}}

\item{common_args}{additional arguments to pass to both
\code{\link{collapse_gt3x.RAW}} and \code{\link{collapse_gt3x.IMU}}}

\item{verbose}{logical. Print information to console?}

\item{...}{additional arguments passed to \code{merge}}
}
\value{
a data frame of merged data
}
\description{
Merge primary accelerometer data with IMU data
}
\examples{
\donttest{
file_3x <- system.file(
  "extdata", "example.gt3x", package = "AGread"
)
AG_3x <- read_gt3x(file_3x)
head(AG_merge(AG_3x))
}
}
