#' AIG: A package for studying Automatic Item Generators.
#'
#' @description The AIG package contains generators for studying automatically generated item types.
#' @details The package will include several generators for psychological research purposes. Currently, it can only generate linear syllogistic reasoning ,arithmetic, and 2D/3D spatial reasoning items.
#' @section Linear Syllogism Generator:
#' This function creates linear syllogsitic reasoning items according to certain specifications given by the arguments. \cr
#' \code{\link{lisy}}
#' @section Arithmetic Generator:
#' This function creates arithmetic items according to certain specifications given by the arguments. \cr
#' \code{\link{arith}}
#' @section Spatial 2D Reasoning Generator:
#' This function creates spatial 2D reasoning items according to certain specifications given by the arguments. \cr
#' \code{\link{spatial2d}}
#' @section Spatial 3D Reasoning Generator:
#' This function creates spatial 3D reasoning items according to certain specifications given by the arguments. \cr
#' \code{\link{spatial3d}} \cr
#'
#' The \code{\link{spatial3d_mirror}} creates the mirror image of the figure created using the spatial3d function.\cr
#'
#' @references
#' Sternberg, R. J. (1980). Representation and process in linear syllogistic reasoning. Journal of Experimental Psychology: General, 109(2), 119.
#'
#' Embretson, S. E. (1999). Generating items during testing: Psychometric issues and models. Psychometrika, 64(4), 407-433.
#'
#' Bejar, I. I. (1990). A generative analysis of a three-dimensional spatial task. \emph{Applied Psychological Measurement}, 14(3), 237-245.
#' @name AIG
NULL


