% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_key_functions.R
\name{set_api_key}
\alias{set_api_key}
\title{Creating a temporary R environment API key variable}
\usage{
set_api_key(key, env_var = "CHATGPT_KEY")
}
\arguments{
\item{key}{Character string with an (ideally encrypt) API key. See how to encrypt key here:
\url{https://httr2.r-lib.org/articles/wrapping-apis.html#basics}. If not provided, it
returns a password box in which the true API key can be secretly entered.}

\item{env_var}{Character string indicating the name of the temporary R environment variable with
the API key and the used AI model. Currently, the argument only takes \code{env_var = "CHATGPT_KEY"}.}
}
\value{
A temporary environment variable with the name from \code{env_var}.
If \code{key} is missing, it returns a password box in which the true API key can be entered.
}
\description{
This function automatically sets/creates an interim R environment variable with
the API key to call a given AI model (e.g. ChatGPT). Thereby users avoid exposing their API keys.
If the API key is set in the console, it will/can be revealed via the .Rhistory.
Find more information about this issue at \url{https://httr2.r-lib.org/articles/wrapping-apis.html}.
}
\details{
When set_api_key() has successfully been executed, \code{get_api_key()} automatically
retrieves the API key from the R environment and the users do not need to specify the API when running
functions from the package that call the API. The API key can be permanently set by
using \code{\link[usethis:edit]{usethis::edit_r_environ()}}. Then write \verb{CHATGPT_KEY=[insert your api key here]} and close
the \code{.Renviron} window and restart R.
}
\note{
Find your personal API key at \url{https://platform.openai.com/account/api-keys}.
}
\examples{
\dontrun{
set_api_key()
}
}
\seealso{
\code{\link{get_api_key}}
}
