% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ala_lists.R
\name{ala_lists}
\alias{ala_lists}
\title{Find ALA species lists}
\usage{
ala_lists(guid, offset = 0, max = 500, verbose = ala_config()$verbose)
}
\arguments{
\item{guid}{string: (optional) if provided, return only lists in which this GUID appears}

\item{offset}{integer: the number of lists to skip. This supports paging}

\item{max}{integer: the maximum number of lists to return. This supports paging}

\item{verbose}{logical: show additional progress information?}
}
\value{
data.frame of list name and other details
}
\description{
Find ALA species lists
}
\examples{
\dontrun{
 ## lists that include the giant African snail Achatina fulica
 ##  (which is a notifiable pest species in some states)
 l <- ala_lists(search_guids("Achatina fulica")$guid)
}

}
\references{
\url{http://lists.ala.org.au} and the associated web services at \url{http://lists.ala.org.au/ws}
}
\seealso{
\code{\link{ala_list}}
}
