% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_fulltext.R
\name{search_fulltext}
\alias{search_fulltext}
\title{Full text search}
\usage{
search_fulltext(query, fq, output_format = "simple", start, page_size,
  sort_by, sort_dir)
}
\arguments{
\item{query}{string: the search term}

\item{fq}{string: (optional) character string or vector of strings, specifying filters to be applied to the 
original query. These are of the form "INDEXEDFIELD:VALUE" e.g. "rk_kingdom:Fungi". 
See \code{ala_fields("general")} for all the fields that are queryable. 
NOTE that fq matches are case-sensitive, but sometimes the entries in the fields are 
not consistent in terms of case (e.g. kingdom names "Fungi" and "Plantae" but "ANIMALIA"). 
fq matches are ANDed by default (e.g. c("field1:abc","field2:def") will match records that have 
field1 value "abc" and field2 value "def"). To obtain OR behaviour, use the form c("field1:abc OR field2:def")}

\item{output_format}{string: controls the print method for the "data" component of the returned object. Either "complete" (the complete data structure is displayed), or "simple" (a simplified version is displayed). Note that the complete data structure exists in both cases: this option only controls what is displayed when the object is printed to the console. The default output format is "simple"}

\item{start}{numeric: (optional) (positive integer) start offset for the results}

\item{page_size}{numeric: (optional) (positive integer) maximum number of records to return. Defaults to the server-side value - currently 10}

\item{sort_by}{string: (optional) field to sort on. See \code{ala_fields("general")} for valid field names}

\item{sort_dir}{string: (optional) sort direction, either "asc" or "desc"}
}
\value{
a named list with the components "meta" (search metadata), "facets" (search facet results), and "data" (the search results, in the form of a data frame). The contents (column names) of the data frame will vary depending on the details of the search and the results, but should contain at least the columns \code{guid}, \code{name}, \code{commonName}, \code{rank}, \code{author}, and \code{occurrenceCount}.
}
\description{
Performs a search across all objects, and selects the closest matches. Generally, the user will provide the search term via the \code{query} parameter, with optional filtering via \code{fq}.
}
\examples{
\dontrun{
 # find information ALA holds on red kangaroo
 search_fulltext("red kangaroo")
 search_fulltext("Heleioporus australiacus")
 search_fulltext("urn:lsid:biodiversity.org.au:afd.taxon:31a9b8b8-4e8f-4343-a15f-2ed24e0bf1ae")

 # find genus names like "Oenanthe"
 search_fulltext("oenanthe", sort_by="rk_kingdom", fq="rank:genus")
}
}
\references{
Associated ALA web service: \url{https://api.ala.org.au/#ws1}
}
\seealso{
\code{\link{ala_fields}}
}
