% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fieldguide.R
\name{fieldguide}
\alias{fieldguide}
\title{Generate a PDF field guide using the ALA's field guide generator}
\usage{
fieldguide(
  guids,
  title = "Field guide",
  filename = tempfile(fileext = ".pdf"),
  overwrite = FALSE
)
}
\arguments{
\item{guids}{character: vector of GUIDs}

\item{title}{string: title to use in the field guide PDF}

\item{filename}{string: filename for the PDF document}

\item{overwrite}{logical: overwrite the file if it already exists?}
}
\value{
filename
}
\description{
Generate a PDF field guide using the ALA's field guide generator
}
\examples{
\dontrun{
fieldguide(guids=
  c("urn:lsid:biodiversity.org.au:afd.taxon:
  95773568-053d-44de-a624-5699f0ac4a59",
  "http://id.biodiversity.org.au/node/apni/2890970"))
}

}
\references{
\url{https://fieldguide.ala.org.au/}
}
\seealso{
\code{\link{search_guids}}
}
